# 🔐 Admin Login - Complete Guide

## Quick Start (First Time Setup)

### Step 1: Create Superuser
Open terminal and run:
```bash
python manage.py createsuperuser
```

**You'll see:**
```
Username: admin
Email address: admin@example.com
Password: ********
Password (again): ********
Superuser created successfully.
```

### Step 2: Start Server
```bash
python manage.py runserver
```

### Step 3: Login to Admin Dashboard
1. Open browser: `http://127.0.0.1:8000/staff/login/`
2. Enter username: `admin` (or whatever you chose)
3. Enter password: (your password)
4. Click "Login"
5. ✅ You're now in the Admin Dashboard!

---

## All Admin Login Methods

### Method 1: Staff Login (Recommended)
**URL:** `http://127.0.0.1:8000/staff/login/`
- Use for: Admin Dashboard access
- Auto-redirects to: Admin Dashboard
- Best for: Daily CRM management

### Method 2: Django Admin
**URL:** `http://127.0.0.1:8000/admin/`
- Use for: Database management
- Access to: All models and data
- Best for: System configuration

---

## Creating Additional Admin Users

### Option A: Through Django Admin

1. **Login to Django Admin:**
   ```
   http://127.0.0.1:8000/admin/
   ```

2. **Create New User:**
   - Click "Users" under "Authentication and Authorization"
   - Click "Add User" button
   - Enter username and password
   - Click "Save"

3. **Add User Details:**
   - Fill in First name, Last name, Email
   - Check "Staff status" (important!)
   - Click "Save"

4. **Create User Profile:**
   - Go back to admin home
   - Click "User profiles" under "CRM"
   - Click "Add User Profile"
   - Select the user you just created
   - Set Role to "Admin"
   - Click "Save"

5. **Test Login:**
   - Go to: `http://127.0.0.1:8000/staff/login/`
   - Login with new credentials
   - Should redirect to Admin Dashboard

### Option B: Through Python Shell

```bash
python manage.py shell
```

Then run:
```python
from django.contrib.auth.models import User
from crm.models import UserProfile

# Create user
user = User.objects.create_user(
    username='admin2',
    email='admin2@example.com',
    password='your_password',
    first_name='Admin',
    last_name='User',
    is_staff=True
)

# Create profile with admin role
profile = UserProfile.objects.create(
    user=user,
    role='admin'
)

print(f"Admin user created: {user.username}")
```

---

## Troubleshooting

### Problem: "Invalid username or password"
**Solution:**
- Make sure you created a superuser first
- Check if you're using the correct username (not email)
- Try resetting password:
  ```bash
  python manage.py changepassword admin
  ```

### Problem: "Please use client login"
**Solution:**
- This means the user has "client" role
- Change role to "admin" in Django admin
- Go to: User profiles → Select user → Change role to "Admin"

### Problem: Redirects to generic staff dashboard
**Solution:**
- User needs to be superuser OR have admin role
- Check in Django admin: User profiles
- Make sure role is set to "admin"

### Problem: Can't access Django admin
**Solution:**
- User needs "Staff status" checked
- Go to Django admin → Users → Select user
- Check "Staff status" box
- Save

---

## Login Flow Diagram

```
User goes to /staff/login/
         ↓
Enters username & password
         ↓
System checks credentials
         ↓
    Valid? ───No──→ Show error message
         ↓
        Yes
         ↓
Check user role
         ↓
    ┌────┴────┐
    │         │
Superuser   Admin Role
    │         │
    └────┬────┘
         ↓
Redirect to Admin Dashboard
(/admin/dashboard/)
```

---

## Quick Reference

### URLs:
- **Staff Login:** `http://127.0.0.1:8000/staff/login/`
- **Admin Dashboard:** `http://127.0.0.1:8000/admin/dashboard/`
- **Django Admin:** `http://127.0.0.1:8000/admin/`
- **Homepage:** `http://127.0.0.1:8000/`

### Commands:
```bash
# Create superuser
python manage.py createsuperuser

# Change password
python manage.py changepassword username

# Start server
python manage.py runserver

# Access shell
python manage.py shell
```

### User Requirements for Admin Access:
- ✅ Username and password
- ✅ is_staff = True (for Django admin)
- ✅ is_superuser = True OR UserProfile.role = 'admin'

---

## Testing Your Admin Login

### Test Checklist:
1. [ ] Created superuser
2. [ ] Started server
3. [ ] Can access staff login page
4. [ ] Can login with credentials
5. [ ] Redirects to admin dashboard
6. [ ] Can see all 8 stat cards
7. [ ] Can access sidebar links
8. [ ] Can logout successfully

### Test Script:
```bash
# 1. Create superuser
python manage.py createsuperuser

# 2. Start server
python manage.py runserver

# 3. Open browser
# Go to: http://127.0.0.1:8000/staff/login/

# 4. Login with superuser credentials

# 5. Verify you see admin dashboard
```

---

## Security Best Practices

### Strong Passwords:
- Minimum 8 characters
- Mix of letters, numbers, symbols
- Don't use common words
- Don't share passwords

### User Management:
- Only give admin role to trusted users
- Regularly review user access
- Remove inactive users
- Use unique usernames

### Session Security:
- Always logout when done
- Don't save passwords in browser on shared computers
- Use HTTPS in production

---

## Common Scenarios

### Scenario 1: First Time Setup
```bash
python manage.py createsuperuser
# Username: admin
# Email: admin@example.com
# Password: (strong password)

python manage.py runserver
# Go to: http://127.0.0.1:8000/staff/login/
# Login with admin credentials
```

### Scenario 2: Adding Team Member as Admin
```
1. Go to: http://127.0.0.1:8000/admin/
2. Create new user
3. Set is_staff = True
4. Create UserProfile with role = 'admin'
5. Give them login URL: http://127.0.0.1:8000/staff/login/
```

### Scenario 3: Forgot Password
```bash
python manage.py changepassword admin
# Enter new password twice
# Login with new password
```

---

## Summary

**To login as admin:**
1. Create superuser: `python manage.py createsuperuser`
2. Start server: `python manage.py runserver`
3. Go to: `http://127.0.0.1:8000/staff/login/`
4. Login with superuser credentials
5. ✅ Access admin dashboard!

**That's it!** You're now logged in as admin and can manage the entire CRM system.
