# CRM System Setup Instructions

## ⚠️ IMPORTANT: Custom User Model Migration

Since we're switching to a custom User model (`crm.User`), we need to handle this carefully.

## Option 1: Fresh Database (Recommended for Development)

If you're okay with resetting the database:

```bash
# 1. Delete the database
del db.sqlite3

# 2. Delete all migration files (except __init__.py)
del main\migrations\0001_initial.py
del assessment\migrations\0001_initial.py
del assessment\migrations\0002_*.py
del assessment\migrations\0003_*.py

# 3. Create fresh migrations
python manage.py makemigrations

# 4. Apply migrations
python manage.py migrate

# 5. Create superuser
python manage.py createsuperuser

# 6. Load sample data (optional)
python manage.py loaddata crm_sample_data.json
```

## Option 2: Keep Existing Data (Complex)

If you need to preserve existing Contact and Assessment data:

1. Export existing data
2. Create new database with custom user
3. Import data back

This is more complex and requires custom migration scripts.

## What I Recommend

For this CRM system, I recommend **Option 1 (Fresh Database)** because:
- We're adding a complete new system
- Existing form submissions can be re-entered if needed
- Cleaner implementation
- Faster setup

## Next Steps After Database Reset

1. Create superuser (Admin)
2. Create sample staff users (CRM, Lead Manager, Project Manager, Employee)
3. Create sample services
4. Test lead capture from forms
5. Test complete workflow

Would you like me to proceed with Option 1?
