# Complete CRM System Architecture

## System Overview
A comprehensive role-based Lead and Project Management CRM integrated with the existing immigration website.

## Core Principles
1. **NO changes to existing website** (design, layout, structure, pages)
2. **Only add**: Client Login/Registration pages + Backend CRM system
3. **Automatic lead capture** from Contact Form and Assessment Form
4. **Email-based matching** for registered users
5. **Strict role-based access control**

## User Roles & Permissions

### 1. Admin (Superuser)
- Full system access
- Create/manage all user accounts (CRM, Lead Manager, Project Manager, Employee)
- View all leads, projects, payments
- Assign leads to Lead Managers
- Approve/reject payments
- Add services for purchase
- View analytics dashboard
- Access activity logs

### 2. Client (Self-registered)
- Separate login/registration pages
- View submitted leads (Contact + Assessment forms)
- View assigned projects and progress
- Purchase services
- Submit payment details + screenshots
- Chat with assigned team (CRM, Lead Manager, Project Manager)
- View task progress (read-only)

### 3. CRM (Staff - Admin created)
- View assigned projects
- Coordinate with clients
- Assign projects to Project Managers
- Approve/reject payments for assigned projects
- Chat with clients and team
- Update project status
- View payment details for assigned projects

### 4. Lead Manager (Staff - Admin created)
- View assigned leads only
- Update lead status (New, Contacted, Qualified, Proposal Sent, Converted, Rejected)
- Convert leads to projects (must select CRM during conversion)
- View payment details for assigned projects
- Chat in project discussions
- Cannot see unassigned leads

### 5. Project Manager (Staff - Admin created)
- View assigned projects only
- Create and assign tasks to Employees
- Update project status
- Chat with team and clients
- Upload/download project files
- **NO access to payment details**
- Track task progress

### 6. Employee (Staff - Admin created)
- View assigned tasks only
- Update task status (Pending, In Progress, Completed)
- Upload task-related files
- Limited chat access (task-related only)
- **NO access to payment details**
- **NO access to project overview**

## Data Flow

### Lead Generation Flow
```
Public User → Contact Form/Assessment Form
    ↓
Auto-saved as Lead in Admin Dashboard
    ↓
Admin assigns to Lead Manager
    ↓
Lead Manager updates status
    ↓
Lead Manager converts to Project (selects CRM)
    ↓
CRM assigns to Project Manager
    ↓
Project Manager creates tasks
    ↓
Tasks assigned to Employees
```

### Service Purchase Flow
```
Client logs in → Purchases Service
    ↓
Auto-creates Project
    ↓
Admin assigns to CRM
    ↓
Client submits payment (Pending status)
    ↓
Admin/CRM approves payment
    ↓
Project becomes Active
    ↓
CRM assigns to Project Manager
    ↓
Normal project workflow continues
```

### Email Matching Flow
```
Non-registered user submits form → Saved as Lead
    ↓
Same user registers with same email
    ↓
System auto-matches email
    ↓
Lead details appear in Client Dashboard
```

## Database Models

### 1. User Model (Extended Django User)
- role (Admin, Client, CRM, Lead Manager, Project Manager, Employee)
- phone_number (encrypted)
- profile_picture
- is_active
- created_by (for staff accounts)
- created_at

### 2. Lead Model
- source (Contact Form / Assessment Form)
- contact_id (FK to Contact model)
- assessment_id (FK to ProfileAssessment model)
- email (for matching)
- status (New, Contacted, Qualified, Proposal Sent, Converted, Rejected)
- assigned_to (FK to Lead Manager)
- assigned_by (FK to Admin)
- notes
- converted_to_project (FK to Project, nullable)
- created_at
- updated_at

### 3. Service Model
- name
- description
- price
- category
- is_active
- created_by (Admin)
- created_at

### 4. Project Model
- title
- description
- client (FK to User - Client)
- lead (FK to Lead, nullable)
- service (FK to Service, nullable)
- crm (FK to User - CRM)
- lead_manager (FK to User - Lead Manager, nullable)
- project_manager (FK to User - Project Manager, nullable)
- status (Pending Payment, Active, On Hold, Completed, Closed)
- start_date
- end_date
- budget
- created_at
- updated_at

### 5. Payment Model
- project (FK to Project)
- client (FK to User)
- amount
- transaction_id (encrypted)
- payment_method
- payment_date
- screenshot (file upload)
- status (Pending, Approved, Rejected)
- approved_by (FK to User - Admin/CRM)
- approved_at
- notes
- created_at

### 6. Task Model
- project (FK to Project)
- title
- description
- assigned_to (FK to User - Employee)
- assigned_by (FK to User - Project Manager)
- status (Pending, In Progress, Completed)
- priority (Low, Medium, High)
- due_date
- completed_at
- created_at
- updated_at

### 7. TaskFile Model
- task (FK to Task)
- file (file upload)
- uploaded_by (FK to User)
- description
- uploaded_at

### 8. ProjectChat Model
- project (FK to Project)
- sender (FK to User)
- message (encrypted)
- is_task_related (boolean)
- task (FK to Task, nullable)
- timestamp
- is_read

### 9. ActivityLog Model
- user (FK to User)
- action
- model_name
- object_id
- description
- ip_address
- timestamp

### 10. Notification Model
- user (FK to User)
- title
- message
- type (Lead Assigned, Task Assigned, Payment Submitted, etc.)
- is_read
- link
- created_at

## URL Structure

### Public URLs (Existing - No Changes)
- `/` - Homepage
- `/assessment/` - Assessment Form
- Contact Form (on homepage)

### New Client URLs
- `/client/login/` - Client Login
- `/client/register/` - Client Registration
- `/client/dashboard/` - Client Dashboard
- `/client/leads/` - View Submitted Leads
- `/client/projects/` - View Projects
- `/client/services/` - Browse & Purchase Services
- `/client/payments/` - Payment History
- `/client/chat/<project_id>/` - Project Chat

### Staff URLs
- `/staff/login/` - Single Staff Login (role-based redirect)
- `/staff/dashboard/` - Role-based Dashboard

### Admin URLs
- `/admin/crm/` - CRM Dashboard
- `/admin/crm/leads/` - Lead Management
- `/admin/crm/projects/` - Project Management
- `/admin/crm/users/` - User Management
- `/admin/crm/services/` - Service Management
- `/admin/crm/payments/` - Payment Management
- `/admin/crm/analytics/` - Analytics Dashboard

### CRM URLs
- `/crm/dashboard/` - CRM Dashboard
- `/crm/projects/` - Assigned Projects
- `/crm/payments/` - Payment Approvals

### Lead Manager URLs
- `/leads/dashboard/` - Lead Manager Dashboard
- `/leads/assigned/` - Assigned Leads
- `/leads/convert/<lead_id>/` - Convert Lead to Project

### Project Manager URLs
- `/pm/dashboard/` - Project Manager Dashboard
- `/pm/projects/` - Assigned Projects
- `/pm/tasks/` - Task Management

### Employee URLs
- `/employee/dashboard/` - Employee Dashboard
- `/employee/tasks/` - Assigned Tasks

## Features Implementation

### 1. Lead Capture System
- Modify Contact Form submission to create Lead
- Modify Assessment Form submission to create Lead
- Auto-populate lead data from form submissions
- Email-based matching for registered users

### 2. Lead Management
- Lead pipeline view (Kanban board)
- Lead assignment workflow
- Status updates with activity logging
- Lead conversion to project

### 3. Project Management
- Project creation from leads or service purchases
- Project assignment workflow
- Status tracking with timeline
- File management
- Progress tracking

### 4. Task Management
- Task creation and assignment
- Task status updates
- File uploads per task
- Due date tracking
- Task-related chat

### 5. Payment System
- Payment submission form with screenshot upload
- Payment approval workflow
- Payment history
- Revenue tracking
- Pending payment alerts

### 6. Chat System
- Project-based chat rooms
- Role-based access control
- Task-related chat threads
- Real-time updates (polling or WebSocket)
- Message encryption

### 7. Analytics Dashboard
- Total Leads (by status)
- Conversion Rate
- Active Projects
- Total Revenue
- Pending Payments
- Task Completion Rate
- User Activity

### 8. Notification System
- Lead assignment notifications
- Task assignment notifications
- Payment submission alerts
- Project status updates
- Chat message notifications

## Security Features

### 1. Data Encryption
- Payment transaction IDs
- Chat messages
- Sensitive client information

### 2. Access Control
- Role-based permissions
- Object-level permissions
- Payment detail restrictions
- Project visibility restrictions

### 3. Activity Logging
- All CRUD operations
- Login/logout tracking
- Permission changes
- Payment approvals

### 4. File Security
- Secure file uploads
- Access control on downloads
- File type validation
- Size limits

## UI/UX Design

### Client Dashboard
- Modern card-based layout
- Service catalog with images
- Project progress bars
- Payment status badges
- Chat interface

### Staff Dashboards
- Sidebar navigation
- Top bar with notifications
- Analytics cards
- Data tables with filters
- Status badges
- Progress indicators
- Action buttons

### Common UI Elements
- Color-coded status badges
- Progress bars
- Timeline views
- Modal dialogs
- Toast notifications
- Loading states
- Empty states

## Technology Stack

### Backend
- Django 4.2.7
- Django REST Framework (for API endpoints)
- Channels (for real-time chat - optional)
- Celery (for background tasks - optional)

### Frontend
- HTML5, CSS3, JavaScript
- No external frameworks (keep it simple)
- Inline styles for CRM pages (avoid conflicts)
- Font Awesome icons
- Chart.js for analytics

### Database
- SQLite (current)
- Can migrate to PostgreSQL for production

### File Storage
- Local file system (development)
- AWS S3 or similar (production)

## Implementation Phases

### Phase 1: Core Setup (Priority)
1. Create CRM app
2. Extend User model with roles
3. Create all database models
4. Set up authentication system
5. Create client login/registration pages

### Phase 2: Lead Management
1. Modify Contact Form to create leads
2. Modify Assessment Form to create leads
3. Create lead management interface
4. Implement lead assignment
5. Build lead conversion workflow

### Phase 3: Project Management
1. Create project management interface
2. Implement project assignment
3. Build task management system
4. Create file upload system

### Phase 4: Payment System
1. Create payment submission form
2. Build payment approval workflow
3. Implement payment tracking
4. Add revenue analytics

### Phase 5: Chat System
1. Create chat interface
2. Implement role-based access
3. Add message encryption
4. Build notification system

### Phase 6: Analytics & Reporting
1. Create analytics dashboard
2. Build reports
3. Add activity logs
4. Implement notifications

## Next Steps

Ready to start implementation? I'll begin with:
1. Creating the CRM app structure
2. Setting up user roles and authentication
3. Creating database models
4. Building client login/registration pages
5. Integrating lead capture from existing forms

Shall I proceed?
