# Quick Reference - Lead & Staff System

## URLs

### Client
- Register: `http://127.0.0.1:8000/client/register/`
- Login: `http://127.0.0.1:8000/client/login/`
- Dashboard: `http://127.0.0.1:8000/client/dashboard/`

### Staff
- Register: `http://127.0.0.1:8000/staff/register/` ⭐ NEW
- Login: `http://127.0.0.1:8000/staff/login/`

### Admin
- Dashboard: `http://127.0.0.1:8000/crm-admin/dashboard/`
- Users: `http://127.0.0.1:8000/crm-admin/users/` ⭐ See pending approvals here
- Leads: `http://127.0.0.1:8000/crm-admin/leads/`

## Key Changes

### Lead Conversion
**Before:** Created user account automatically
**Now:** Only creates project, stores email, user registers later

### Staff Registration
**Before:** Admin creates all staff accounts
**Now:** Staff can self-register, admin approves

## Common Tasks

### Convert Lead (Admin)
1. Admin Dashboard → Leads
2. Click lead → "Convert to Project"
3. Fill details → Submit
4. ✓ Project created without user account

### Register Client
1. Go to `/client/register/`
2. Use SAME email from lead
3. Submit form
4. ✓ Projects automatically linked

### Register Staff
1. Go to `/staff/register/`
2. Fill form, select role
3. Submit
4. ✓ Wait for admin approval

### Approve Staff (Admin)
1. Admin Dashboard → Users
2. See "Pending Approvals" section
3. Click "Approve" or "Reject"
4. ✓ Staff can now login

## Database Fields

### Project Model
```python
client = ForeignKey(User, null=True)  # Can be None
client_email = EmailField()  # Stores email for linking
```

### UserProfile Model
```python
is_approved = BooleanField(default=True)
approval_requested_at = DateTimeField()
approved_by = ForeignKey(User)
approved_at = DateTimeField()
```

## Testing

Run test script:
```bash
python test_lead_staff_system.py
```

Check system:
```bash
python manage.py check
```

## Troubleshooting

### Client can't see projects after registration
- Check email matches exactly (case-insensitive)
- Verify project has client_email set
- Check project client field is now set to user

### Staff can't login after registration
- This is normal - account needs admin approval
- Check admin has approved the account
- Verify is_approved = True in database

### Pending approvals not showing
- Check user has is_approved = False
- Verify role is staff (not client or admin)
- Refresh admin users page

## Migration

If you need to re-run migration:
```bash
python manage.py migrate crm 0004  # Rollback
python manage.py migrate crm 0005  # Apply new migration
```

## Support Files

- `LEAD_STAFF_SYSTEM_COMPLETE.md` - Full documentation
- `SYSTEM_WORKFLOWS.md` - Visual workflows
- `IMPLEMENTATION_SUMMARY.md` - Summary
- `test_lead_staff_system.py` - Test script

## Status: ✓ Production Ready
