# CRM System - Quick Start Guide

## 🚀 Getting Started

### Step 1: Run Migrations
The CRM models are already created. Just apply them:

```bash
python manage.py makemigrations
python manage.py migrate
```

### Step 2: Start the Server
```bash
python manage.py runserver
```

### Step 3: Access the System

#### For Clients:
1. **Register:** http://127.0.0.1:8000/client/register/
   - Fill in your details
   - Create username and password
   - Auto-login after registration

2. **Login:** http://127.0.0.1:8000/client/login/
   - Use your username and password
   - Access your dashboard

3. **Dashboard:** http://127.0.0.1:8000/client/dashboard/
   - View your leads (from contact/assessment forms)
   - View your projects
   - Browse and purchase services
   - Submit payments

#### For Staff:
1. **Create Staff User in Django Admin:**
   - Go to http://127.0.0.1:8000/admin/
   - Login as superuser
   - Go to "User profiles"
   - Create new user profile
   - Set role (CRM, Lead Manager, Project Manager, Employee)

2. **Staff Login:** http://127.0.0.1:8000/staff/login/
   - Use staff username and password
   - Auto-redirect to role-based dashboard

## 📋 Testing the System

### Test 1: Lead Capture from Contact Form
1. Go to homepage: http://127.0.0.1:8000/
2. Scroll to contact form
3. Fill in details with email: test@example.com
4. Submit form
5. Go to Django admin → Leads
6. You should see a new lead with source "Contact Form"

### Test 2: Lead Capture from Assessment Form
1. Go to: http://127.0.0.1:8000/assessment/
2. Fill in assessment form with email: test@example.com
3. Submit form
4. Go to Django admin → Leads
5. You should see a new lead with source "Assessment Form"

### Test 3: Email Matching
1. Register as client with email: test@example.com
2. Login to client dashboard
3. Go to "My Leads"
4. You should see both leads (contact + assessment) matched by email

### Test 4: Service Purchase
1. Login as client
2. Go to "Browse Services"
3. First, create a service in Django admin:
   - Go to http://127.0.0.1:8000/admin/crm/service/
   - Add new service (name, price, description)
   - Set "is_active" to True
4. Refresh services page
5. Click "Purchase" on a service
6. Go to "My Projects"
7. You should see new project with status "Pending Payment"

### Test 5: Payment Submission
1. Login as client
2. Go to "Payments"
3. You should see pending projects
4. Fill in payment form:
   - Amount
   - Transaction ID
   - Payment method
   - Payment date
   - Upload screenshot
5. Submit payment
6. Go to Django admin → Payments
7. You should see payment with status "Pending"

## 🎯 Key Features Working

### ✅ Client Features:
- Registration and login
- Dashboard with stats
- View leads (matched by email)
- View projects
- Browse services
- Purchase services (creates project)
- Submit payments
- Activity logging
- Notifications

### ✅ Lead Capture:
- Automatic lead creation from contact form
- Automatic lead creation from assessment form
- Email-based matching for registered users
- Works retroactively (register after submitting forms)

### ✅ Staff Features:
- Role-based login
- Auto-redirect to role-specific dashboard
- Admin dashboard (basic)
- CRM dashboard (basic)
- Lead Manager dashboard (basic)
- Project Manager dashboard (basic)
- Employee dashboard (basic)

## 📊 Current System Status

### Database Models: ✅ Complete
- UserProfile (with roles)
- Lead (with form integration)
- Service
- Project
- Payment (with encryption)
- Task
- TaskFile
- ProjectChat (with encryption)
- ActivityLog
- Notification

### Views (Controllers): ✅ Phase 1 Complete
- Client authentication (login, register, logout)
- Client dashboard views (dashboard, leads, projects, services, payments)
- Staff authentication (login, logout)
- Role-based dashboards (basic structure)
- Service purchase workflow
- Payment submission workflow

### Templates (UI): ✅ Phase 1 Complete
- Client login page (beautiful design)
- Client registration page (professional form)
- Client dashboard (modern layout with sidebar)
- Staff login page (coming in Phase 2)
- Role-based dashboards (coming in Phase 2)

### Integration: ✅ Complete
- Contact form → Lead creation
- Assessment form → Lead creation
- Homepage → Client login/register links
- Email matching system
- Activity logging
- Notifications

## 🔄 Workflow Examples

### Example 1: New Client Journey
```
1. User visits homepage
2. Submits contact form (email: john@example.com)
   → Lead created automatically
3. Later, user registers with same email
   → UserProfile created with role 'client'
4. User logs in
   → Dashboard shows the lead from contact form
5. User purchases a service
   → Project created with status 'pending_payment'
6. User submits payment
   → Payment created with status 'pending'
7. Admin approves payment
   → Project status changes to 'active'
```

### Example 2: Lead Management (Coming in Phase 2)
```
1. Admin sees new lead in dashboard
2. Admin assigns lead to Lead Manager
   → Notification sent to Lead Manager
3. Lead Manager contacts client
4. Lead Manager updates status to 'Contacted'
5. Lead Manager converts lead to project
   → Selects CRM during conversion
6. CRM assigns project to Project Manager
7. Project Manager creates tasks
8. Tasks assigned to Employees
```

## 🎨 UI Preview

### Client Login Page:
- Two-column layout
- Left: Purple gradient with features list
- Right: Login form with error handling
- Links to registration and homepage

### Client Dashboard:
- Sidebar navigation (purple gradient)
- Top bar with user info
- Stats cards (4 cards with color coding)
- Recent leads table
- Recent projects table
- Empty states with call-to-action buttons

### Design System:
- Primary: Purple gradient (#667eea → #764ba2)
- Success: Green (#10b981)
- Warning: Orange (#f59e0b)
- Danger: Red (#ef4444)
- Info: Blue (#3b82f6)

## 🐛 Troubleshooting

### Issue: "No module named 'crm'"
**Solution:** Make sure you ran migrations:
```bash
python manage.py makemigrations
python manage.py migrate
```

### Issue: "Reverse for 'client_login' not found"
**Solution:** Check that crm.urls is included in myproject/urls.py

### Issue: Leads not appearing in client dashboard
**Solution:** 
1. Check that email matches exactly
2. Check Django admin → Leads to verify lead was created
3. Make sure you're logged in as the correct user

### Issue: Can't purchase services
**Solution:** Create services in Django admin first:
- Go to http://127.0.0.1:8000/admin/crm/service/
- Add new service
- Set "is_active" to True

### Issue: Payment submission fails
**Solution:** 
1. Make sure project exists and belongs to logged-in user
2. Check that all required fields are filled
3. Make sure screenshot file is uploaded

## 📝 Next Steps

### Phase 2: Complete Staff Dashboards
- Full admin dashboard with analytics
- Lead management interface (Kanban board)
- Project management interface
- Task management system
- Payment approval interface
- Chat system
- Advanced analytics

### Phase 3: Advanced Features
- Real-time notifications
- File management system
- Advanced search and filters
- Export functionality
- Email notifications
- SMS notifications
- Calendar integration

## 🎉 Success!

Your CRM system is now functional! Clients can register, view their leads, purchase services, and submit payments. The system automatically captures leads from your existing forms and matches them to registered users.

**Ready to test?** Start with registering a new client and exploring the dashboard!
