# Staff Login URLs - CONFIDENTIAL

## ⚠️ IMPORTANT - KEEP THIS INFORMATION SECURE
These URLs are hidden from the public website and should only be shared with authorized staff members.

## Staff Portal Access URLs

### Staff Login (Admin, CRM, Lead Manager, PM, Employee)
```
http://127.0.0.1:8000/system/auth/staff-portal/
```
**Production URL**: `https://yourdomain.com/system/auth/staff-portal/`

### Staff Registration (Self-Registration - Requires Admin Approval)
```
http://127.0.0.1:8000/system/auth/staff-register/
```
**Production URL**: `https://yourdomain.com/system/auth/staff-register/`

## Why Hidden URLs?

1. **Security**: Staff login is not linked anywhere on the public website
2. **Access Control**: Only authorized personnel know the URL
3. **Reduced Attack Surface**: Bots and unauthorized users won't find the login page
4. **Professional**: Separates public client access from internal staff access

## URL Structure

The URLs use a non-obvious path structure:
- `/system/auth/staff-portal/` - Not easily guessable
- Not linked from any public pages
- No "staff login" buttons on the main website

## Client vs Staff Access

### Client Access (Public)
- **Login**: `http://127.0.0.1:8000/client/login/`
- **Register**: `http://127.0.0.1:8000/client/register/`
- These ARE linked on the public website

### Staff Access (Hidden)
- **Login**: `http://127.0.0.1:8000/system/auth/staff-portal/`
- **Register**: `http://127.0.0.1:8000/system/auth/staff-register/`
- These are NOT linked on the public website

## How to Share with Staff

### Option 1: Direct Communication
Send the URL directly via:
- Email to authorized staff
- Internal company chat/Slack
- Onboarding documentation

### Option 2: Bookmark
Instruct staff to bookmark the URL after first access

### Option 3: Internal Documentation
Keep in secure internal wiki or documentation system

## Staff Roles and Dashboards

After logging in at `/system/auth/staff-portal/`, users are redirected based on role:

| Role | Redirect URL |
|------|-------------|
| Admin | `/crm-admin/dashboard/` |
| CRM | `/crm/dashboard/` |
| Lead Manager | `/leads/dashboard/` |
| Project Manager | `/pm/dashboard/` |
| Employee | `/employee/dashboard/` |

## Testing

Test the new URLs:

```bash
# Staff Login
http://127.0.0.1:8000/system/auth/staff-portal/

# Staff Register
http://127.0.0.1:8000/system/auth/staff-register/
```

## Old URLs (No Longer Work)

These URLs have been changed and will return 404:
- ❌ `/staff/login/` (OLD)
- ❌ `/staff/register/` (OLD)

## Security Best Practices

1. **Never** link to staff login from public pages
2. **Never** mention staff login URL in public documentation
3. **Change** the URL periodically for extra security
4. **Use** HTTPS in production
5. **Enable** rate limiting on login attempts
6. **Monitor** failed login attempts
7. **Require** strong passwords for staff accounts

## Customizing the URL

To change the URL to something else, edit `crm/urls.py`:

```python
# Example: Change to your own secret path
path('your-secret-path-here/', views.staff_login, name='staff_login'),
```

Suggestions for secret paths:
- `/internal/team-access/`
- `/secure/portal/`
- `/admin-xyz123/`
- `/team/login-2024/`
- Use a random string: `/auth-k8j2n9x4/`

## Status
✅ UPDATED - Staff login URLs are now hidden from public access
