# System Workflows - Visual Guide

## Workflow 1: Lead to Client Journey (New System)

```
┌─────────────────────────────────────────────────────────────────┐
│                    LEAD SUBMISSION                               │
│  User fills contact/assessment form → Lead created in system    │
└────────────────────────┬────────────────────────────────────────┘
                         │
                         ▼
┌─────────────────────────────────────────────────────────────────┐
│                  ADMIN CONVERTS LEAD                             │
│  Admin reviews lead → Clicks "Convert to Project"               │
│  ✓ Project created with client_email                            │
│  ✓ NO user account created                                      │
│  ✓ Lead marked as "Converted"                                   │
└────────────────────────┬────────────────────────────────────────┘
                         │
                         ▼
┌─────────────────────────────────────────────────────────────────┐
│              CLIENT REGISTERS (Later)                            │
│  User visits /client/register/                                   │
│  Fills form with SAME email from lead                           │
│  ✓ User account created                                         │
│  ✓ System finds projects with matching email                   │
│  ✓ Projects automatically linked to user                        │
│  ✓ Notifications sent                                           │
└────────────────────────┬────────────────────────────────────────┘
                         │
                         ▼
┌─────────────────────────────────────────────────────────────────┐
│                CLIENT DASHBOARD                                  │
│  Client logs in → Sees all linked projects                      │
│  Can view project details, make payments, chat with team        │
└─────────────────────────────────────────────────────────────────┘
```

## Workflow 2: Staff Self-Registration (New System)

```
┌─────────────────────────────────────────────────────────────────┐
│              STAFF VISITS REGISTRATION PAGE                      │
│  URL: /staff/register/                                           │
│  Fills form: Name, Email, Role, Username, Password             │
│  Selects Role: CRM, Lead Manager, PM, or Employee              │
└────────────────────────┬────────────────────────────────────────┘
                         │
                         ▼
┌─────────────────────────────────────────────────────────────────┐
│                ACCOUNT CREATED (Pending)                         │
│  ✓ User account created                                         │
│  ✓ is_approved = False                                          │
│  ✓ Cannot login yet                                             │
│  ✓ Admin receives notification                                  │
│  ✓ Success message shown to staff                               │
└────────────────────────┬────────────────────────────────────────┘
                         │
                         ▼
┌─────────────────────────────────────────────────────────────────┐
│              ADMIN REVIEWS REGISTRATION                          │
│  Admin Dashboard → Users → Pending Approvals                    │
│  Reviews: Name, Email, Role, Request Date                       │
│                                                                  │
│  ┌──────────────┐         ┌──────────────┐                     │
│  │   APPROVE    │   OR    │    REJECT    │                     │
│  └──────┬───────┘         └──────┬───────┘                     │
│         │                        │                              │
└─────────┼────────────────────────┼──────────────────────────────┘
          │                        │
          ▼                        ▼
┌──────────────────┐    ┌──────────────────────┐
│  STAFF APPROVED  │    │   STAFF REJECTED     │
│  ✓ is_approved   │    │  ✓ Account deleted   │
│    = True        │    │  ✓ Activity logged   │
│  ✓ Can login now │    │                      │
│  ✓ Notification  │    │                      │
│    sent          │    │                      │
└────────┬─────────┘    └──────────────────────┘
         │
         ▼
┌──────────────────────────────────────────────┐
│         STAFF LOGS IN                        │
│  Staff Dashboard → Role-based access         │
└──────────────────────────────────────────────┘
```

## Workflow 3: Admin Project Creation (Existing Feature)

```
┌─────────────────────────────────────────────────────────────────┐
│              ADMIN CREATES PROJECT DIRECTLY                      │
│  Admin Dashboard → Projects → Create Project                    │
│  Selects: Client, Service, CRM Staff                            │
│  ✓ Project created                                              │
│  ✓ Linked to existing client user                               │
│  ✓ Notifications sent to client and CRM                         │
│  ✓ Invoice generated when payment approved                      │
└─────────────────────────────────────────────────────────────────┘
```

## Comparison: Old vs New System

### Lead Conversion

#### OLD SYSTEM ❌
```
Lead → Admin Converts → User Account Auto-Created
                      → Random Password Generated
                      → Email Sent with Credentials
                      → User CANNOT register again
                      → Security Risk (password in email)
```

#### NEW SYSTEM ✓
```
Lead → Admin Converts → Project Created (no user)
                      → Email stored in project
                      → User Registers Later
                      → Projects Auto-Linked
                      → User Chooses Own Password
                      → Better Security & UX
```

### Staff Registration

#### OLD SYSTEM ❌
```
Staff → Contacts Admin → Admin Creates Account
                       → Admin Sets Password
                       → Admin Sends Credentials
                       → Time-consuming for Admin
```

#### NEW SYSTEM ✓
```
Staff → Self-Registers → Account Created (Pending)
                       → Admin Approves/Rejects
                       → Staff Can Login
                       → Less Admin Work
                       → Better Control
```

## Key Benefits

### 1. Lead Conversion
- ✓ No automatic user creation
- ✓ Users choose own credentials
- ✓ Better security (no passwords in email)
- ✓ Automatic project linking
- ✓ Better user experience

### 2. Staff Registration
- ✓ Self-service registration
- ✓ Admin approval control
- ✓ Less admin workload
- ✓ Professional workflow
- ✓ Audit trail

### 3. Security
- ✓ Users control their passwords
- ✓ No random passwords
- ✓ Admin approval for staff
- ✓ Role restrictions
- ✓ Activity logging

### 4. User Experience
- ✓ Intuitive registration
- ✓ Clear approval status
- ✓ Automatic project linking
- ✓ Professional interface
- ✓ Better communication

## Access URLs

### Client Portal
- Login: `/client/login/`
- Register: `/client/register/`
- Dashboard: `/client/dashboard/`
- Projects: `/client/projects/`
- Payments: `/client/payments/`

### Staff Portal
- Login: `/staff/login/`
- Register: `/staff/register/` (NEW)
- Dashboard: Role-based redirect

### Admin Portal
- Dashboard: `/crm-admin/dashboard/`
- Users: `/crm-admin/users/`
- Leads: `/crm-admin/leads/`
- Projects: `/crm-admin/projects/`
- Payments: `/crm-admin/payments/`

## Role-Based Dashboards

```
┌─────────────────────────────────────────────────────────────────┐
│                        STAFF LOGIN                               │
└────────────────────────┬────────────────────────────────────────┘
                         │
         ┌───────────────┼───────────────┐
         │               │               │
         ▼               ▼               ▼
    ┌────────┐      ┌────────┐     ┌────────┐
    │ Admin  │      │  CRM   │     │Lead Mgr│
    │Dashboard│     │Dashboard│    │Dashboard│
    └────────┘      └────────┘     └────────┘
         │               │               │
         ▼               ▼               ▼
    ┌────────┐      ┌────────┐     ┌────────┐
    │Project │      │Employee│     │        │
    │Manager │      │Dashboard│    │        │
    └────────┘      └────────┘     └────────┘
```

## Database Schema Changes

### Project Model
```python
# OLD
client = ForeignKey(User)  # Required

# NEW
client = ForeignKey(User, null=True, blank=True)  # Optional
client_email = EmailField(null=True, blank=True)  # Store email
```

### UserProfile Model
```python
# NEW FIELDS
is_approved = BooleanField(default=True)
approval_requested_at = DateTimeField(null=True)
approved_by = ForeignKey(User, null=True)
approved_at = DateTimeField(null=True)
```

## Testing Checklist

- [x] Lead conversion without user creation
- [x] Client registration with project linking
- [x] Staff self-registration
- [x] Admin approval workflow
- [x] Staff login with approval check
- [x] Pending approvals display
- [x] Notifications sent correctly
- [x] Activity logging
- [x] Database migrations
- [x] Backward compatibility

## Status: ✓ Complete and Production Ready

All workflows tested and working as expected!
