# Template Structure Documentation

## Overview
The project now uses Django template inheritance with reusable header and footer components.

## File Structure

```
templates/
├── base.html                    # Base template with header/footer
├── includes/
│   ├── header.html             # Reusable navigation header
│   └── footer.html             # Reusable footer
└── index_clean.html            # Homepage (needs to be updated to extend base.html)

assessment/templates/assessment/
├── form.html                   # Assessment form (extends base.html)
├── form_v2.html               # Old version (can be deleted)
├── results_v2.html            # Results page (needs to be updated)
```

## How to Use

### 1. Base Template (base.html)
Contains:
- HTML structure
- Common CSS (navigation, footer, responsive)
- Header include
- Footer include
- Common JavaScript

### 2. Creating a New Page

```django
{% extends 'base.html' %}
{% load static %}

{% block title %}Your Page Title{% endblock %}

{% block extra_css %}
<style>
    /* Page-specific CSS */
</style>
{% endblock %}

{% block content %}
    <!-- Your page content here -->
{% endblock %}

{% block extra_js %}
<script>
    // Page-specific JavaScript
</script>
{% endblock %}
```

### 3. Header (includes/header.html)
- Navigation bar
- Logo and branding
- Menu links
- Mobile toggle
- Active link highlighting

### 4. Footer (includes/footer.html)
- Company info
- Quick links
- Services list
- Contact information
- Newsletter signup
- Social media links
- Copyright

## Benefits

1. **Consistency**: Header and footer are identical across all pages
2. **Maintainability**: Update header/footer once, applies everywhere
3. **Clean Code**: Each page only contains its specific content
4. **Easy Updates**: Change navigation or footer without touching every page
5. **Reusability**: Create new pages quickly by extending base.html

## Next Steps

To complete the migration:

1. Update `index_clean.html` to extend `base.html`
2. Update `assessment/templates/assessment/results_v2.html` to extend `base.html`
3. Delete old template versions (form_v2.html, etc.)
4. Update view to use new template names

## Example: Assessment Form

The assessment form (`assessment/templates/assessment/form.html`) now:
- Extends `base.html`
- Includes only assessment-specific CSS
- Contains only the form content
- Automatically gets header and footer

## Active Link Highlighting

The header automatically highlights the active page:
```django
<a href="/" class="nav-link {% if request.path == '/' %}active{% endif %}">Home</a>
```

This checks the current URL path and adds the 'active' class accordingly.
