# Verification Status Fix

## Issue
Client profile was showing "Not Verified" even after admin approved the verification.

## Root Cause
There was a mismatch between the status values used in different parts of the code:
- **Model definition**: Uses `'verified'` as the approved status
- **Admin verification function**: Was using `'approved'` (incorrect)
- **Client profile template**: Was checking for `'verified'` (correct)

## Solution
Updated all code to consistently use `'verified'` as the approved status value.

## Files Modified

### 1. crm/views.py
**Function**: `admin_verify_client()`
- Changed: `profile.verification_status = 'approved'`
- To: `profile.verification_status = 'verified'`

### 2. crm/templates/crm/admin/user_edit.html
**Template condition**:
- Changed: `{% elif edit_user.profile.verification_status == 'approved' %}`
- To: `{% elif edit_user.profile.verification_status == 'verified' %}`

**CSS badge class**:
- Changed: `.badge.approved`
- To: `.badge.verified`
- Changed: `.badge.not_submitted`
- To: `.badge.unverified`

### 3. test_verification_system.py
**Variable names**:
- Changed: `approved` → `verified`
- Changed: `not_submitted` → `unverified`

## Data Migration
Created `fix_verification_status.py` script to update existing data:
- Finds all profiles with `verification_status='approved'`
- Updates them to `verification_status='verified'`
- Result: 1 profile updated (Harry singh)

## Verification Status Values
The correct status values as defined in the model are:
1. `'unverified'` - Default status, no ID proof uploaded
2. `'pending'` - ID proof uploaded, awaiting admin review
3. `'verified'` - Admin approved the ID proof ✓
4. `'rejected'` - Admin rejected the ID proof

## Client Profile Display
Now correctly shows:
- ✅ **Verified Account** (green badge) - when status is 'verified'
- ⏱️ **Verification Pending** (orange badge) - when status is 'pending'
- ❌ **Verification Rejected** (red badge) - when status is 'rejected'
- ⚠️ **Not Verified** (gray badge) - when status is 'unverified'

## Testing
Run the test script to verify:
```bash
python test_verification_system.py
```

Expected output:
- Harry singh: Status = Verified ✓
- Client profile page should show green "Verified Account" badge

## Status
✅ FIXED - All verification statuses now use consistent values
