# 🎨 CRM System Visual Guide

## 📱 User Interface Overview

### 1. Client Login Page
**URL:** `/client/login/`

**Design:**
- Two-column layout
- Left side: Purple gradient background with features list
- Right side: White background with login form
- Links to registration and homepage

**Features:**
- Username and password fields
- Error message display
- "Register here" link
- "Back to Homepage" link

**Colors:**
- Background: Purple gradient (#667eea → #764ba2)
- Form: White with blue focus states
- Buttons: Purple gradient

---

### 2. Client Registration Page
**URL:** `/client/register/`

**Design:**
- Two-column layout
- Left side: Purple gradient with benefits list
- Right side: Registration form with multiple fields

**Form Fields:**
- First Name & Last Name (side by side)
- Email Address
- Phone Number (optional)
- Username
- Password & Confirm Password (side by side)

**Features:**
- Form validation
- Error message display
- "Login here" link for existing users
- Auto-login after registration

---

### 3. Client Dashboard
**URL:** `/client/dashboard/`

**Layout:**
```
┌─────────────────────────────────────────────────────┐
│  Sidebar (260px)  │  Main Content Area              │
│                   │                                  │
│  Immigration CRM  │  Top Bar (User Info)            │
│  Client Portal    │  ─────────────────────────────  │
│                   │                                  │
│  ☰ Dashboard      │  Stats Cards (4 cards)          │
│  ☰ My Leads       │  ┌────┐ ┌────┐ ┌────┐ ┌────┐  │
│  ☰ My Projects    │  │ 12 │ │  5 │ │  3 │ │  1 │  │
│  ☰ Browse Services│  └────┘ └────┘ └────┘ └────┘  │
│  ☰ Payments       │                                  │
│                   │  Recent Leads Table              │
│  ─────────────    │  ─────────────────────────────  │
│  ☰ Logout         │  Recent Projects Table           │
│                   │                                  │
└─────────────────────────────────────────────────────┘
```

**Components:**
1. **Sidebar (Fixed Left)**
   - Purple gradient background
   - Navigation menu
   - Logout button

2. **Top Bar**
   - Page title
   - User avatar (initials)
   - User name and email

3. **Stats Cards (4 cards in grid)**
   - Total Leads (Blue border)
   - Total Projects (Green border)
   - Active Projects (Purple border)
   - Pending Payments (Orange border)

4. **Recent Leads Table**
   - Source column
   - Status badge
   - Submitted date
   - "View All Leads" button

5. **Recent Projects Table**
   - Project name
   - Status badge
   - Created date
   - "View All Projects" button

---

### 4. My Leads Page
**URL:** `/client/leads/`

**Design:**
- Same sidebar layout
- Lead cards in grid layout
- Each card shows:
  - Source badge (top left)
  - Status badge (top right)
  - Name, Email, Phone
  - Assigned to (if any)
  - Submitted date
  - Conversion status

**Lead Card Example:**
```
┌─────────────────────────────────────┐
│ Contact Form        [New]           │
│                                     │
│ Name: John Doe                      │
│ Email: john@example.com             │
│ Phone: +1 234 567 8900              │
│ Assigned to: Lead Manager           │
│ ─────────────────────────────────   │
│ Submitted: Jan 15, 2026             │
└─────────────────────────────────────┘
```

**Empty State:**
- Large icon (📋)
- "No Leads Yet" message
- "Go to Homepage" button

---

### 5. Staff Login Page
**URL:** `/staff/login/`

**Design:**
- Two-column layout
- Left side: Blue gradient with role list
- Right side: Login form

**Roles Listed:**
- Admin - Full system access
- CRM - Project coordination
- Lead Manager - Lead conversion
- Project Manager - Task management
- Employee - Task execution

**Features:**
- Username and password fields
- Info box explaining staff accounts
- "Are you a client? Login here" link
- "Back to Homepage" link

**Colors:**
- Background: Blue gradient (#1e3a8a → #3b82f6)
- Form: White with blue focus states

---

### 6. Staff Dashboard
**URL:** `/staff/dashboard/`

**Design:**
- Centered card layout
- User icon at top
- Welcome message
- User information box
- "Under Construction" message
- Action buttons

**Features:**
- Shows user's full name
- Displays username, email, role
- Links to admin panel
- Link to homepage
- Logout button

---

## 🎨 Design System

### Color Palette

**Primary Colors:**
```
Purple Gradient: #667eea → #764ba2
Blue Gradient:   #1e3a8a → #3b82f6
```

**Status Colors:**
```
Success:  #10b981 (Green)
Warning:  #f59e0b (Orange)
Danger:   #ef4444 (Red)
Info:     #3b82f6 (Blue)
```

**Status Badges:**
```
New:           Blue background (#dbeafe)
Contacted:     Yellow background (#fef3c7)
Qualified:     Indigo background (#e0e7ff)
Proposal Sent: Pink background (#fce7f3)
Converted:     Green background (#d1fae5)
Rejected:      Red background (#fee2e2)
Active:        Green background (#d1fae5)
Pending:       Orange background (#fed7aa)
```

**Neutral Colors:**
```
Background:    #f5f7fa (Light gray)
Card:          #ffffff (White)
Border:        #e0e0e0 (Light gray)
Text Primary:  #333333 (Dark gray)
Text Secondary:#666666 (Medium gray)
Text Muted:    #999999 (Light gray)
```

### Typography

**Font Family:**
```
'Segoe UI', Tahoma, Geneva, Verdana, sans-serif
```

**Font Sizes:**
```
Page Title:    28px (bold)
Section Title: 20px (bold)
Card Title:    16px (semi-bold)
Body Text:     15px (regular)
Small Text:    14px (regular)
Badge Text:    12px (semi-bold)
```

### Spacing

**Padding:**
```
Card:          25px
Section:       30px
Button:        12px 30px
Badge:         4px 12px
```

**Margins:**
```
Section Gap:   30px
Card Gap:      20px
Element Gap:   15px
```

### Border Radius

```
Card:          12px
Button:        8px
Badge:         20px (pill shape)
Avatar:        50% (circle)
```

### Shadows

```
Card:          0 2px 10px rgba(0, 0, 0, 0.05)
Card Hover:    0 4px 15px rgba(102, 126, 234, 0.1)
Login Box:     0 20px 60px rgba(0, 0, 0, 0.3)
```

### Animations

**Transitions:**
```
All:           0.3s ease
Transform:     0.2s ease
```

**Hover Effects:**
```
Button:        translateY(-2px)
Card:          border-color change + shadow
Link:          color change
```

---

## 📐 Layout Specifications

### Sidebar
```
Width:         260px
Position:      Fixed left
Height:        100vh
Background:    Purple gradient
Padding:       20px
```

### Main Content
```
Margin Left:   260px
Padding:       30px
Background:    #f5f7fa
```

### Top Bar
```
Background:    White
Padding:       20px 30px
Border Radius: 12px
Margin Bottom: 30px
Shadow:        0 2px 10px rgba(0, 0, 0, 0.05)
```

### Stats Grid
```
Display:       Grid
Columns:       repeat(auto-fit, minmax(250px, 1fr))
Gap:           20px
```

### Responsive Breakpoints
```
Mobile:        max-width: 768px
  - Sidebar becomes full width
  - Stats grid becomes single column
  - Main content margin-left: 0
```

---

## 🎯 Component Examples

### Button Styles

**Primary Button:**
```css
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
color: white;
padding: 14px;
border-radius: 8px;
font-weight: 600;
```

**Secondary Button:**
```css
background: #e5e7eb;
color: #374151;
padding: 12px 30px;
border-radius: 10px;
font-weight: 600;
```

### Card Styles

**Stat Card:**
```css
background: white;
padding: 25px;
border-radius: 12px;
box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
border-left: 4px solid [color];
```

**Lead Card:**
```css
border: 2px solid #f0f0f0;
border-radius: 12px;
padding: 20px;
transition: all 0.3s;

hover:
  border-color: #667eea;
  box-shadow: 0 4px 15px rgba(102, 126, 234, 0.1);
```

### Table Styles

**Table Header:**
```css
background: #f8f9fa;
color: #666;
font-weight: 600;
font-size: 14px;
padding: 12px;
```

**Table Row:**
```css
border-bottom: 1px solid #f0f0f0;
padding: 12px;
color: #333;
```

---

## 📱 Responsive Design

### Mobile (< 768px)

**Changes:**
1. Sidebar becomes full width, not fixed
2. Main content margin-left: 0
3. Stats grid: 1 column
4. Form rows: 1 column
5. Top bar: stack vertically
6. Tables: horizontal scroll

**Example:**
```
Mobile Layout:
┌─────────────────┐
│   Sidebar       │
│   (Full Width)  │
├─────────────────┤
│   Top Bar       │
├─────────────────┤
│   Stat Card 1   │
├─────────────────┤
│   Stat Card 2   │
├─────────────────┤
│   Stat Card 3   │
├─────────────────┤
│   Stat Card 4   │
├─────────────────┤
│   Content       │
└─────────────────┘
```

---

## 🎨 Visual Hierarchy

### Priority Levels

**Level 1 (Highest):**
- Page titles (28px, bold)
- Primary action buttons
- Status badges

**Level 2:**
- Section titles (20px, bold)
- Stats values (32px, bold)
- User names

**Level 3:**
- Card titles (16px, semi-bold)
- Form labels
- Table headers

**Level 4:**
- Body text (15px, regular)
- Table data
- Descriptions

**Level 5 (Lowest):**
- Small text (14px, regular)
- Timestamps
- Helper text

---

## ✨ Interactive Elements

### Hover States

**Buttons:**
- Transform: translateY(-2px)
- Shadow increase

**Cards:**
- Border color change
- Shadow appearance

**Links:**
- Color change to primary
- Underline appearance

**Sidebar Menu:**
- Background: rgba(255, 255, 255, 0.2)

### Focus States

**Input Fields:**
- Border color: Primary color
- Outline: none
- Transition: 0.3s

### Active States

**Sidebar Menu:**
- Background: rgba(255, 255, 255, 0.2)
- Bottom border (for nav links)

---

## 🎯 Accessibility

**Features:**
- High contrast text
- Clear focus indicators
- Semantic HTML
- Descriptive labels
- Error messages
- Empty states with guidance

**Color Contrast:**
- Text on white: #333 (AAA)
- Text on gradient: white (AAA)
- Badge text: High contrast

---

This visual guide provides a complete reference for the CRM system's design and layout. All components follow a consistent design system for a professional, cohesive user experience.
