from django.contrib import admin
from .models import ProfileAssessment

@admin.register(ProfileAssessment)
class ProfileAssessmentAdmin(admin.ModelAdmin):
    list_display = ['get_full_name', 'get_email', 'field_of_expertise', 'eligibility_status', 'total_score', 'created_at']
    list_filter = ['eligibility_status', 'field_of_expertise', 'created_at']
    search_fields = []  # Can't search encrypted fields
    readonly_fields = [
        'assessment_id', 'created_at', 'updated_at', 'total_score', 
        'percentage_score', 'criteria_met', 'eligibility_status', 'get_personal_info'
    ]
    
    fieldsets = (
        ('Personal Information (Decrypted)', {
            'fields': ('get_personal_info',)
        }),
        ('Professional Details', {
            'fields': ('field_of_expertise', 'years_of_experience')
        }),
        ('EB-1A Criteria Scores', {
            'fields': (
                'original_contributions',
                'published_material',
                'judging_work',
                'scholarly_articles',
                'leading_role',
                'high_salary',
                'exhibitions',
                'membership',
                'awards',
                'commercial_success'
            )
        }),
        ('Assessment Results', {
            'fields': ('total_score', 'percentage_score', 'criteria_met', 'eligibility_status')
        }),
        ('Metadata', {
            'fields': ('assessment_id', 'created_at', 'updated_at')
        }),
    )
    
    def get_personal_info(self, obj):
        """Display decrypted personal information"""
        phone = f"{obj.country_code} {obj.get_phone_number()}" if obj.get_phone_number() else 'N/A'
        return f"""Name: {obj.get_full_name()}
Email: {obj.get_email()}
Phone: {phone}
Location: {obj.get_current_location()}"""
    get_personal_info.short_description = 'Personal Details'
    
    def has_add_permission(self, request):
        # Disable adding assessments through admin
        return False
