import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Project, User

print("\n" + "="*80)
print("ASSIGN CRM TO PROJECT")
print("="*80 + "\n")

# Get the CRM user
crm_user = User.objects.filter(profile__role='crm').first()
if not crm_user:
    print("❌ No CRM user found!")
    exit()

print(f"CRM User: {crm_user.get_full_name()} ({crm_user.email})")

# Get projects without CRM assigned
projects_without_crm = Project.objects.filter(crm__isnull=True)
print(f"\nProjects without CRM: {projects_without_crm.count()}")

for project in projects_without_crm:
    print(f"\n  Project: {project.title}")
    print(f"  Client: {project.client.get_full_name()}")
    print(f"  Status: {project.status}")
    
    # Assign CRM
    project.crm = crm_user
    project.save()
    print(f"  ✓ Assigned to {crm_user.get_full_name()}")

print(f"\n✓ All projects now have CRM assigned!")
