from assessment.models import ProfileAssessment

print("All assessments in database:")
print("=" * 50)

for assessment in ProfileAssessment.objects.all().order_by('-created_at'):
    print(f"ID: {assessment.id}")
    print(f"Assessment ID: {assessment.assessment_id}")
    print(f"Name: {assessment.get_full_name()}")
    print(f"Email: {assessment.get_email()}")
    print(f"Encrypted data length: {len(assessment.first_name_encrypted)} bytes")
    print(f"Encrypted format: {assessment.first_name_encrypted[:20]}...")
    print(f"Created: {assessment.created_at}")
    print("-" * 30)