import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Lead, Project

print("=" * 60)
print("CONVERTED LEADS CHECK")
print("=" * 60)

converted_leads = Lead.objects.filter(status='converted')

for lead in converted_leads:
    print(f"\nLead: {lead.get_full_name()}")
    print(f"Email: {lead.email}")
    print(f"Assigned to Lead Manager: {lead.assigned_to.get_full_name() if lead.assigned_to else 'Not assigned'}")
    print(f"Project: {lead.converted_to_project}")
    if lead.converted_to_project:
        project = lead.converted_to_project
        print(f"  - Project Title: {project.title}")
        print(f"  - Project Status: {project.get_status_display()}")
        print(f"  - CRM Assigned: {project.crm.get_full_name() if project.crm else 'Not assigned'}")
        print(f"  - Lead Manager: {project.lead_manager.get_full_name() if project.lead_manager else 'Not assigned'}")

print("\n" + "=" * 60)
