#!/usr/bin/env python
"""
Script to check leads in the database
"""
import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Lead
from main.models import Contact
from assessment.models import ProfileAssessment

print("=" * 60)
print("LEADS CHECK")
print("=" * 60)

# Check contacts
contacts = Contact.objects.all()
print(f"\nTotal Contacts: {contacts.count()}")
for contact in contacts:
    print(f"  - {contact.get_first_name()} {contact.get_last_name()} | {contact.get_email()}")

# Check assessments
assessments = ProfileAssessment.objects.all()
print(f"\nTotal Assessments: {assessments.count()}")
for assessment in assessments:
    print(f"  - {assessment.get_first_name()} {assessment.get_last_name()} | {assessment.get_email()}")

# Check leads
leads = Lead.objects.all()
print(f"\nTotal Leads: {leads.count()}")
for lead in leads:
    print(f"  - {lead.first_name} {lead.last_name} | {lead.email} | Source: {lead.get_source_display()} | Status: {lead.get_status_display()}")

print("\n" + "=" * 60)
print("LEAD CREATION STATUS")
print("=" * 60)

if contacts.count() > 0 and leads.filter(source='contact').count() == 0:
    print("\n⚠ WARNING: Contacts exist but no leads created from contact form!")
    print("   Lead creation may not be working in contact form submission.")

if assessments.count() > 0 and leads.filter(source='assessment').count() == 0:
    print("\n⚠ WARNING: Assessments exist but no leads created from assessment form!")
    print("   Lead creation may not be working in assessment form submission.")

if leads.count() == 0:
    print("\n⚠ No leads found in database!")
    print("   Leads should be automatically created when:")
    print("   1. Contact form is submitted")
    print("   2. Assessment form is submitted")
else:
    print(f"\n✓ {leads.count()} leads found in database")
