import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Project, Payment
from django.contrib.auth.models import User

# Get all pending payment projects
pending_projects = Project.objects.filter(status='pending_payment').order_by('created_at')

print(f"\n{'='*80}")
print(f"PENDING PAYMENT PROJECTS")
print(f"{'='*80}\n")

for project in pending_projects:
    print(f"Project ID: {project.project_id}")
    print(f"Title: {project.title}")
    print(f"Client: {project.client.get_full_name()} ({project.client.email})")
    print(f"Amount: ${project.budget}")
    print(f"Created: {project.created_at}")
    print(f"Status: {project.status}")
    
    # Check if payment exists
    payments = Payment.objects.filter(project=project)
    print(f"Payments: {payments.count()}")
    
    print("-" * 80)

print(f"\nTotal pending projects: {pending_projects.count()}")

# Ask if user wants to delete duplicates
print("\n" + "="*80)
response = input("\nDo you want to delete duplicate test projects? (yes/no): ").lower()

if response == 'yes':
    # Group by client and service
    from collections import defaultdict
    grouped = defaultdict(list)
    
    for project in pending_projects:
        key = (project.client.id, project.service.service_id if project.service else None)
        grouped[key].append(project)
    
    deleted_count = 0
    for key, projects in grouped.items():
        if len(projects) > 1:
            # Keep the first one, delete the rest
            print(f"\nFound {len(projects)} duplicate projects for same client/service")
            for project in projects[1:]:  # Skip first, delete rest
                print(f"  Deleting: {project.title} (Created: {project.created_at})")
                project.delete()
                deleted_count += 1
    
    print(f"\n✓ Deleted {deleted_count} duplicate projects")
    
    # Show remaining
    remaining = Project.objects.filter(status='pending_payment').count()
    print(f"✓ Remaining pending projects: {remaining}")
else:
    print("\nNo changes made.")
