#!/usr/bin/env python
"""
Script to verify staff role counts
"""
import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.contrib.auth.models import User
from crm.models import UserProfile

print("=" * 60)
print("STAFF ROLE COUNTS VERIFICATION")
print("=" * 60)

# Count by role
crm_count = User.objects.filter(profile__role='crm').count()
lead_manager_count = User.objects.filter(profile__role='lead_manager').count()
project_manager_count = User.objects.filter(profile__role='project_manager').count()
employee_count = User.objects.filter(profile__role='employee').count()
client_count = User.objects.filter(profile__role='client').count()
admin_count = User.objects.filter(is_superuser=True).count()

print(f"\nCRM Staff: {crm_count}")
print(f"Lead Managers: {lead_manager_count}")
print(f"Project Managers: {project_manager_count}")
print(f"Employees: {employee_count}")
print(f"Clients: {client_count}")
print(f"Admins (Superusers): {admin_count}")

print("\n" + "=" * 60)
print("ALL USERS (excluding superusers)")
print("=" * 60)

users = User.objects.filter(is_superuser=False).order_by('profile__role', 'username')
for user in users:
    try:
        role = user.profile.get_role_display()
        print(f"{user.username:20} | {user.email:30} | {role}")
    except:
        print(f"{user.username:20} | {user.email:30} | No Profile")

print("\n" + "=" * 60)
print("SUPERUSERS (not shown in users list)")
print("=" * 60)

superusers = User.objects.filter(is_superuser=True)
for user in superusers:
    print(f"{user.username:20} | {user.email:30} | Superuser")

print("\n✓ Verification complete!")
