"""
Check if superuser exists and show details
Run with: python manage.py shell < check_superuser.py
"""

from django.contrib.auth.models import User

print("\n" + "="*60)
print("SUPERUSER CHECK")
print("="*60)

# Check for superusers
superusers = User.objects.filter(is_superuser=True)

if superusers.exists():
    print(f"\n✓ Found {superusers.count()} superuser(s):\n")
    
    for user in superusers:
        print(f"Username: {user.username}")
        print(f"Email: {user.email}")
        print(f"First Name: {user.first_name}")
        print(f"Last Name: {user.last_name}")
        print(f"Is Active: {user.is_active}")
        print(f"Is Staff: {user.is_staff}")
        print(f"Date Joined: {user.date_joined}")
        print(f"Last Login: {user.last_login}")
        print("-" * 60)
else:
    print("\n✗ No superuser found!")
    print("\nTo create a superuser, run:")
    print("  python manage.py createsuperuser")

# Check all users
all_users = User.objects.all()
print(f"\nTotal Users in Database: {all_users.count()}")

if all_users.count() > 0:
    print("\nAll Users:")
    for user in all_users:
        status = "Superuser" if user.is_superuser else "Staff" if user.is_staff else "Regular"
        print(f"  - {user.username} ({user.email}) - {status}")

print("\n" + "="*60)
print("LOGIN INSTRUCTIONS")
print("="*60)
print("\n1. If superuser exists:")
print("   - Go to: http://127.0.0.1:8000/staff/login/")
print("   - Login with username and password")
print("   - You'll be redirected to admin dashboard")
print("\n2. If no superuser exists:")
print("   - Run: python manage.py createsuperuser")
print("   - Follow the prompts to create one")
print("\n3. Forgot password?")
print("   - Run: python manage.py changepassword username")
print("   - Enter new password twice")
print("\n" + "="*60 + "\n")
