import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Payment, Project

print("\n" + "="*80)
print("CLEAR ALL PAYMENT DATA")
print("="*80 + "\n")

# Get counts before deletion
payment_count = Payment.objects.count()
pending_projects = Project.objects.filter(status='pending_payment').count()

print(f"Current payments in database: {payment_count}")
print(f"Projects with pending_payment status: {pending_projects}")

# Show all payments
if payment_count > 0:
    print("\nPayments to be deleted:")
    print("-" * 80)
    for payment in Payment.objects.all():
        print(f"  - Payment ID: {payment.payment_id}")
        print(f"    Project: {payment.project.title}")
        print(f"    Client: {payment.client.get_full_name()}")
        print(f"    Amount: ${payment.amount}")
        print(f"    Status: {payment.status}")
        print(f"    Date: {payment.payment_date}")
        print()

# Confirm deletion
response = input("\nDo you want to delete ALL payments? (yes/no): ").lower()

if response == 'yes':
    # Delete all payments
    deleted_count = Payment.objects.all().delete()[0]
    print(f"\n✓ Deleted {deleted_count} payment records")
    
    # Reset all projects to pending_payment if they have no payments
    projects_reset = 0
    for project in Project.objects.all():
        if not project.payments.exists() and project.status != 'pending_payment':
            project.status = 'pending_payment'
            project.save()
            projects_reset += 1
    
    if projects_reset > 0:
        print(f"✓ Reset {projects_reset} projects to pending_payment status")
    
    print("\n✓ All payment data cleared successfully!")
    print(f"✓ Remaining payments: {Payment.objects.count()}")
    print(f"✓ Projects with pending_payment status: {Project.objects.filter(status='pending_payment').count()}")
else:
    print("\nNo changes made.")

print("\n" + "="*80)
