#!/usr/bin/env python
"""
Script to create leads from existing contacts and assessments
"""
import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Lead
from main.models import Contact
from assessment.models import ProfileAssessment

print("=" * 60)
print("CREATE MISSING LEADS")
print("=" * 60)

created_count = 0

# Create leads from contacts
print("\n1. Processing Contacts...")
contacts = Contact.objects.all()
for contact in contacts:
    # Check if lead already exists
    email = contact.get_email()
    if not Lead.objects.filter(source='contact', email=email, contact=contact).exists():
        try:
            lead = Lead.objects.create(
                source='contact',
                contact=contact,
                email=email,
                first_name=contact.get_first_name(),
                last_name=contact.get_last_name(),
                phone=contact.get_phone(),
                status='new'
            )
            print(f"   ✓ Created lead from contact: {lead.get_full_name()} ({email})")
            created_count += 1
        except Exception as e:
            print(f"   ✗ Error creating lead from contact {email}: {e}")
    else:
        print(f"   - Lead already exists for contact: {email}")

# Create leads from assessments
print("\n2. Processing Assessments...")
assessments = ProfileAssessment.objects.all()
for assessment in assessments:
    # Check if lead already exists
    email = assessment.get_email()
    if not Lead.objects.filter(source='assessment', email=email, assessment=assessment).exists():
        try:
            lead = Lead.objects.create(
                source='assessment',
                assessment=assessment,
                email=email,
                first_name=assessment.get_first_name(),
                last_name=assessment.get_last_name(),
                phone=assessment.get_phone_number(),
                status='new'
            )
            print(f"   ✓ Created lead from assessment: {lead.get_full_name()} ({email})")
            created_count += 1
        except Exception as e:
            print(f"   ✗ Error creating lead from assessment {email}: {e}")
    else:
        print(f"   - Lead already exists for assessment: {email}")

print("\n" + "=" * 60)
print(f"SUMMARY: Created {created_count} new leads")
print("=" * 60)

# Show all leads
leads = Lead.objects.all().order_by('-created_at')
print(f"\nTotal Leads in Database: {leads.count()}")
for lead in leads:
    print(f"  - {lead.get_full_name():30} | {lead.email:30} | {lead.get_source_display():15} | {lead.get_status_display()}")

print("\n✓ Done!")
