from django.urls import path
from . import views

urlpatterns = [
    # Client URLs
    path('client/login/', views.client_login, name='client_login'),
    path('client/register/', views.client_register, name='client_register'),
    path('client/logout/', views.client_logout, name='client_logout'),
    path('client/dashboard/', views.client_dashboard, name='client_dashboard'),
    path('client/profile/', views.client_profile, name='client_profile'),
    path('client/leads/', views.client_leads, name='client_leads'),
    path('client/projects/', views.client_projects, name='client_projects'),
    path('client/projects/<uuid:project_id>/', views.client_project_detail, name='client_project_detail'),
    path('client/projects/<uuid:project_id>/send-message/', views.client_send_message, name='client_send_message'),
    path('client/services/', views.client_services, name='client_services'),
    path('client/services/<uuid:service_id>/purchase/', views.purchase_service, name='purchase_service'),
    path('client/payments/', views.client_payments, name='client_payments'),
    path('client/payments/submit/', views.submit_payment, name='submit_payment'),
    path('invoice/<uuid:payment_id>/', views.view_invoice, name='view_invoice'),
    
    # Staff URLs (hidden/secure paths)
    path('system/auth/staff-portal/', views.staff_login, name='staff_login'),
    path('system/auth/staff-register/', views.staff_register, name='staff_register'),
    path('staff/logout/', views.staff_logout, name='staff_logout'),
    path('staff/dashboard/', views.staff_dashboard, name='staff_dashboard'),
    
    # Admin CRM Dashboard URLs (changed from admin/ to crm-admin/ to avoid conflict)
    path('crm-admin/dashboard/', views.admin_dashboard, name='admin_dashboard'),
    path('crm-admin/leads/', views.admin_leads, name='admin_leads'),
    path('crm-admin/leads/<uuid:lead_id>/', views.admin_lead_detail, name='admin_lead_detail'),
    path('crm-admin/leads/<uuid:lead_id>/assign/', views.admin_lead_assign, name='admin_lead_assign'),
    path('crm-admin/leads/<uuid:lead_id>/assign-crm/', views.admin_lead_assign_crm, name='admin_lead_assign_crm'),
    path('crm-admin/leads/<uuid:lead_id>/update-status/', views.admin_lead_update_status, name='admin_lead_update_status'),
    path('crm-admin/leads/<uuid:lead_id>/update-notes/', views.admin_lead_update_notes, name='admin_lead_update_notes'),
    path('crm-admin/leads/<uuid:lead_id>/convert/', views.admin_lead_convert, name='admin_lead_convert'),
    path('crm-admin/projects/', views.admin_projects, name='admin_projects'),
    path('crm-admin/projects/create/', views.admin_create_project, name='admin_create_project'),
    path('crm-admin/projects/<uuid:project_id>/', views.admin_project_detail, name='admin_project_detail'),
    path('crm-admin/projects/<uuid:project_id>/assign-crm/', views.admin_assign_crm, name='admin_assign_crm'),
    path('crm-admin/projects/<uuid:project_id>/assign-pm/', views.admin_assign_pm, name='admin_assign_pm'),
    path('crm-admin/payments/', views.admin_payments, name='admin_payments'),
    path('crm-admin/payments/<uuid:payment_id>/update-status/', views.admin_update_payment_status, name='admin_update_payment_status'),
    path('crm-admin/services/', views.admin_services, name='admin_services'),
    path('crm-admin/services/add/', views.admin_service_add, name='admin_service_add'),
    path('crm-admin/services/<uuid:service_id>/edit/', views.admin_service_edit, name='admin_service_edit'),
    path('crm-admin/services/<uuid:service_id>/toggle/', views.admin_service_toggle, name='admin_service_toggle'),
    path('crm-admin/users/', views.admin_users, name='admin_users'),
    path('crm-admin/users/add/', views.admin_user_add, name='admin_user_add'),
    path('crm-admin/users/<int:user_id>/edit/', views.admin_user_edit, name='admin_user_edit'),
    path('crm-admin/users/<int:user_id>/delete/', views.admin_user_delete, name='admin_user_delete'),
    path('crm-admin/users/<int:user_id>/approve/', views.admin_approve_staff, name='admin_approve_staff'),
    path('crm-admin/users/<int:user_id>/reject/', views.admin_reject_staff, name='admin_reject_staff'),
    path('crm-admin/users/<int:user_id>/verify/', views.admin_verify_client, name='admin_verify_client'),
    path('crm-admin/users/<int:user_id>/reject-verification/', views.admin_reject_verification, name='admin_reject_verification'),
    path('crm-admin/contacts/', views.admin_contacts, name='admin_contacts'),
    path('crm-admin/contacts/<int:contact_id>/', views.admin_contact_detail, name='admin_contact_detail'),
    path('crm-admin/contacts/<int:contact_id>/toggle-read/', views.admin_contact_toggle_read, name='admin_contact_toggle_read'),
    
    # CRM URLs
    path('crm/dashboard/', views.crm_dashboard, name='crm_dashboard'),
    path('crm/projects/<uuid:project_id>/', views.crm_project_detail, name='crm_project_detail'),
    path('crm/projects/<uuid:project_id>/assign-pm/', views.crm_assign_pm, name='crm_assign_pm'),
    path('crm/projects/<uuid:project_id>/send-message/', views.crm_send_message, name='crm_send_message'),
    path('crm/projects/<uuid:project_id>/upload-file/', views.crm_upload_file, name='crm_upload_file'),
    path('crm/payments/<uuid:payment_id>/update-status/', views.crm_update_payment_status, name='crm_update_payment_status'),
    
    # Lead Manager URLs
    path('leads/dashboard/', views.lead_manager_dashboard, name='lead_manager_dashboard'),
    path('leads/<uuid:lead_id>/assessment/', views.lead_manager_view_assessment, name='lead_manager_view_assessment'),
    
    # Project Manager URLs
    path('pm/dashboard/', views.pm_dashboard, name='pm_dashboard'),
    path('pm/projects/<uuid:project_id>/', views.pm_project_detail, name='pm_project_detail'),
    path('pm/projects/<uuid:project_id>/create-task/', views.pm_create_task, name='pm_create_task'),
    path('pm/projects/<uuid:project_id>/send-message/', views.pm_send_message, name='pm_send_message'),
    path('pm/projects/<uuid:project_id>/complete/', views.pm_complete_project, name='pm_complete_project'),
    path('pm/projects/<uuid:project_id>/upload-file/', views.pm_upload_project_file, name='pm_upload_project_file'),
    path('pm/project-files/<int:file_id>/delete/', views.pm_delete_project_file, name='pm_delete_project_file'),
    
    # Employee URLs
    path('employee/dashboard/', views.employee_dashboard, name='employee_dashboard'),
    path('employee/tasks/<uuid:task_id>/', views.employee_task_detail, name='employee_task_detail'),
    path('employee/tasks/<uuid:task_id>/update-status/', views.employee_update_task_status, name='employee_update_task_status'),
    path('employee/tasks/<uuid:task_id>/upload-file/', views.employee_upload_file, name='employee_upload_file'),
    path('employee/files/<uuid:file_id>/delete/', views.employee_delete_file, name='employee_delete_file'),
    
    # Notification API URLs
    path('api/notifications/', views.get_notifications, name='get_notifications'),
    path('api/notifications/<uuid:notification_id>/read/', views.mark_notification_read, name='mark_notification_read'),
    path('api/notifications/mark-all-read/', views.mark_all_notifications_read, name='mark_all_notifications_read'),
    
    # Chat API URLs
    path('api/projects/<uuid:project_id>/messages/', views.get_project_messages, name='get_project_messages'),
]
