"""
Fix admin profile issue
Run with: python manage.py shell < fix_admin_profile.py
"""

from django.contrib.auth.models import User
from crm.models import UserProfile

print("\n" + "="*60)
print("FIXING ADMIN PROFILE")
print("="*60)

# Get the admin user
try:
    admin_user = User.objects.get(username='admin')
    print(f"\n✓ Found admin user: {admin_user.username}")
    
    # Check if profile exists
    try:
        profile = admin_user.profile
        print(f"✓ Profile exists with role: {profile.get_role_display()}")
        
        # Update role to admin if needed
        if profile.role != 'admin':
            profile.role = 'admin'
            profile.save()
            print(f"✓ Updated role to: admin")
        
    except UserProfile.DoesNotExist:
        print("✗ No profile found. Creating one...")
        
        # Create profile for admin
        profile = UserProfile.objects.create(
            user=admin_user,
            role='admin'
        )
        print(f"✓ Created profile with role: admin")
    
    print("\n" + "="*60)
    print("ADMIN DETAILS")
    print("="*60)
    print(f"Username: {admin_user.username}")
    print(f"Email: {admin_user.email}")
    print(f"Is Superuser: {admin_user.is_superuser}")
    print(f"Is Staff: {admin_user.is_staff}")
    print(f"Is Active: {admin_user.is_active}")
    print(f"Profile Role: {profile.get_role_display()}")
    
    print("\n" + "="*60)
    print("✓ ADMIN READY TO LOGIN!")
    print("="*60)
    print("\nLogin at: http://127.0.0.1:8000/staff/login/")
    print(f"Username: {admin_user.username}")
    print("Password: (your password)")
    print("\n" + "="*60 + "\n")
    
except User.DoesNotExist:
    print("\n✗ Admin user not found!")
    print("\nCreate one with: python manage.py createsuperuser")
    print("\n" + "="*60 + "\n")
