"""
Fix verification status from 'approved' to 'verified'
"""
import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import UserProfile

def fix_verification_status():
    """Fix any profiles with 'approved' status to 'verified'"""
    print("=" * 60)
    print("FIXING VERIFICATION STATUS")
    print("=" * 60)
    
    # Find profiles with 'approved' status (old value)
    profiles_to_fix = UserProfile.objects.filter(verification_status='approved')
    count = profiles_to_fix.count()
    
    if count == 0:
        print("\n✓ No profiles need fixing. All verification statuses are correct.")
    else:
        print(f"\nFound {count} profile(s) with 'approved' status")
        print("Updating to 'verified'...\n")
        
        for profile in profiles_to_fix:
            old_status = profile.verification_status
            profile.verification_status = 'verified'
            profile.save()
            print(f"✓ Fixed: {profile.user.get_full_name()} - {old_status} → verified")
        
        print(f"\n✓ Successfully updated {count} profile(s)")
    
    # Show current status breakdown
    print("\n" + "=" * 60)
    print("CURRENT STATUS BREAKDOWN")
    print("=" * 60)
    
    pending = UserProfile.objects.filter(role='client', verification_status='pending').count()
    verified = UserProfile.objects.filter(role='client', verification_status='verified').count()
    rejected = UserProfile.objects.filter(role='client', verification_status='rejected').count()
    unverified = UserProfile.objects.filter(role='client', verification_status='unverified').count()
    
    print(f"\nClient Verification Statuses:")
    print(f"  - Pending: {pending}")
    print(f"  - Verified: {verified}")
    print(f"  - Rejected: {rejected}")
    print(f"  - Unverified: {unverified}")
    
    print("\n" + "=" * 60)
    print("FIX COMPLETE")
    print("=" * 60)

if __name__ == '__main__':
    fix_verification_status()
