from django.contrib import admin
from .models import Contact

@admin.register(Contact)
class ContactAdmin(admin.ModelAdmin):
    list_display = ['get_full_name', 'get_email', 'get_subject', 'submitted_at', 'is_read']
    list_filter = ['is_read', 'submitted_at']
    search_fields = []  # Can't search encrypted fields
    readonly_fields = ['get_contact_info', 'submitted_at', 'ip_address']
    
    fieldsets = (
        ('Contact Information', {
            'fields': ('get_contact_info',)
        }),
        ('Metadata', {
            'fields': ('submitted_at', 'ip_address', 'is_read')
        }),
    )
    
    def get_contact_info(self, obj):
        """Display decrypted contact information"""
        info = f"""
Name: {obj.get_full_name()}
Email: {obj.get_email()}
Phone: {obj.get_phone() or 'N/A'}
Subject: {obj.get_subject()}
Message: {obj.get_message()}
        """
        return info.strip()
    get_contact_info.short_description = 'Contact Details'
    
    def has_add_permission(self, request):
        # Disable adding contacts through admin
        return False
