from django.shortcuts import render
from django.http import JsonResponse
from django.views.decorators.http import require_http_methods
from django.views.decorators.csrf import csrf_exempt
import json
from .models import Contact

def index(request):
    """Render the main immigration website page"""
    return render(request, 'index_clean.html')

@require_http_methods(["POST"])
@csrf_exempt
def submit_contact(request):
    """Handle contact form submission with encryption"""
    try:
        # Parse JSON data
        data = json.loads(request.body)
        
        # Create contact instance
        contact = Contact()
        contact.set_first_name(data.get('firstName', ''))
        contact.set_last_name(data.get('lastName', ''))
        contact.set_email(data.get('email', ''))
        contact.set_phone(data.get('phone', ''))
        contact.set_subject(data.get('subject', ''))
        contact.set_message(data.get('message', ''))
        
        # Get IP address
        x_forwarded_for = request.META.get('HTTP_X_FORWARDED_FOR')
        if x_forwarded_for:
            contact.ip_address = x_forwarded_for.split(',')[0]
        else:
            contact.ip_address = request.META.get('REMOTE_ADDR')
        
        # Save to database
        contact.save()
        
        # Create Lead in CRM system
        try:
            from crm.models import Lead
            lead = Lead.objects.create(
                source='contact',
                contact=contact,
                email=data.get('email', ''),
                first_name=data.get('firstName', ''),
                last_name=data.get('lastName', ''),
                phone=data.get('phone', ''),
                status='new'
            )
        except Exception as lead_error:
            # Log error but don't fail the contact submission
            print(f"Lead creation error: {lead_error}")
        
        return JsonResponse({
            'success': True,
            'message': 'Thank you! Your message has been sent successfully. We will get back to you soon.'
        })
        
    except Exception as e:
        return JsonResponse({
            'success': False,
            'message': f'An error occurred: {str(e)}'
        }, status=400)
