#!/usr/bin/env python
"""
Script to reset a lead's status for testing
"""
import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Lead, Project

lead_id = '796f9627-5d5d-4d37-96a5-f9ca92225070'

try:
    lead = Lead.objects.get(lead_id=lead_id)
    
    print(f"Current Lead Status: {lead.get_status_display()}")
    print(f"Assigned to: {lead.assigned_to.get_full_name() if lead.assigned_to else 'Unassigned'}")
    
    if lead.converted_to_project:
        print(f"Converted to Project: {lead.converted_to_project.title}")
        if lead.converted_to_project.crm:
            print(f"Assigned to CRM: {lead.converted_to_project.crm.get_full_name()}")
        
        # Delete the project
        project = lead.converted_to_project
        print(f"\nDeleting project: {project.title}")
        project.delete()
    
    # Reset lead status
    lead.status = 'new'
    lead.converted_to_project = None
    lead.converted_at = None
    lead.save()
    
    print(f"\n✓ Lead status reset to: {lead.get_status_display()}")
    print(f"✓ Lead ID: {lead.lead_id}")
    print(f"✓ Lead Name: {lead.get_full_name()}")
    print(f"✓ Assigned to: {lead.assigned_to.get_full_name() if lead.assigned_to else 'Unassigned'}")
    print("\nYou can now test the conversion workflow again!")
    
except Lead.DoesNotExist:
    print(f"Lead with ID {lead_id} not found!")
except Exception as e:
    print(f"Error: {e}")
