"""
Test script to verify assessment form encryption is working
Run this with: python manage.py shell < test_assessment_encryption.py
"""

from assessment.models import ProfileAssessment

print("=" * 60)
print("TESTING ASSESSMENT FORM ENCRYPTION")
print("=" * 60)

# Create a test assessment
print("\n1. Creating test assessment with encrypted data...")
assessment = ProfileAssessment()
assessment.set_first_name("Jane")
assessment.set_last_name("Smith")
assessment.set_email("jane.smith@example.com")
assessment.set_phone_number("+1234567890")
assessment.country_code = "+1"
assessment.set_current_location("San Francisco, CA")
assessment.field_of_expertise = "Technology & Engineering"
assessment.years_of_experience = "6-10 years"

# Set some criteria scores
assessment.original_contributions = 3
assessment.published_material = 2
assessment.judging_work = 2
assessment.scholarly_articles = 3
assessment.leading_role = 2
assessment.high_salary = 2
assessment.exhibitions = 1
assessment.membership = 2
assessment.awards = 2
assessment.commercial_success = 1

assessment.save()
assessment.calculate_scores()

print(f"✅ Assessment created with ID: {assessment.assessment_id}")
print(f"✅ Created at: {assessment.created_at}")

print("\n2. Encrypted Data (as stored in database):")
print("-" * 60)
print(f"First Name (encrypted): {assessment.first_name_encrypted[:50]}...")
print(f"Email (encrypted): {assessment.email_encrypted[:50]}...")
print(f"Location (encrypted): {assessment.current_location_encrypted[:50]}...")

print("\n3. Decrypted Data (readable):")
print("-" * 60)
print(f"Full Name: {assessment.get_full_name()}")
print(f"Email: {assessment.get_email()}")
print(f"Phone: {assessment.country_code} {assessment.get_phone_number()}")
print(f"Location: {assessment.get_current_location()}")
print(f"Field of Expertise: {assessment.field_of_expertise}")
print(f"Years of Experience: {assessment.years_of_experience}")

print("\n4. Assessment Results:")
print("-" * 60)
print(f"Total Score: {assessment.total_score}/30")
print(f"Percentage: {assessment.percentage_score:.1f}%")
print(f"Criteria Met: {assessment.criteria_met}/10")
print(f"Eligibility Status: {assessment.eligibility_status}")
print(f"Strength Level: {assessment.get_strength_level()}")

print("\n5. Testing Backward Compatibility Properties:")
print("-" * 60)
print(f"assessment.first_name: {assessment.first_name}")
print(f"assessment.email: {assessment.email}")
print(f"assessment.current_location: {assessment.current_location}")

print("\n6. Recommendations:")
print("-" * 60)
recommendations = assessment.get_recommendations()
if recommendations:
    for i, rec in enumerate(recommendations, 1):
        print(f"{i}. {rec}")
else:
    print("No recommendations - excellent profile!")

print("\n" + "=" * 60)
print("✅ ENCRYPTION/DECRYPTION WORKING CORRECTLY!")
print("=" * 60)
print(f"\nView in admin: http://127.0.0.1:8000/admin/assessment/profileassessment/{assessment.id}/change/")
print(f"View results: http://127.0.0.1:8000/assessment/results/{assessment.assessment_id}/")
print("\n")
