import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Project, ProjectChat
from django.contrib.auth.models import User

# Get a project
projects = Project.objects.all()
print(f"\n=== Total Projects: {projects.count()} ===")

if projects.exists():
    project = projects.first()
    print(f"\nProject: {project.title}")
    print(f"Project ID: {project.project_id}")
    print(f"Client: {project.client.get_full_name()}")
    print(f"CRM: {project.crm.get_full_name() if project.crm else 'Not assigned'}")
    print(f"PM: {project.project_manager.get_full_name() if project.project_manager else 'Not assigned'}")
    
    # Get chat messages for this project
    messages = ProjectChat.objects.filter(project=project).order_by('timestamp')
    print(f"\n=== Chat Messages for this project: {messages.count()} ===")
    
    for msg in messages:
        print(f"\nMessage ID: {msg.message_id}")
        print(f"Sender: {msg.sender.get_full_name()}")
        print(f"Timestamp: {msg.timestamp}")
        try:
            print(f"Message: {msg.message}")
        except Exception as e:
            print(f"Error decrypting message: {e}")
    
    # Try to create a test message
    print("\n=== Creating Test Message ===")
    try:
        test_msg = ProjectChat()
        test_msg.project = project
        test_msg.sender = project.client
        test_msg.set_message("Test message from client")
        test_msg.save()
        print(f"✓ Test message created successfully!")
        print(f"Message ID: {test_msg.message_id}")
        print(f"Decrypted: {test_msg.message}")
    except Exception as e:
        print(f"✗ Error creating test message: {e}")
    
    # Check again
    messages = ProjectChat.objects.filter(project=project).order_by('timestamp')
    print(f"\n=== Total messages now: {messages.count()} ===")
else:
    print("No projects found!")
