"""
Quick test script to verify contact form encryption is working
Run this with: python manage.py shell < test_contact_encryption.py
"""

from main.models import Contact

# Create a test contact
print("Creating test contact with encrypted data...")
contact = Contact()
contact.set_first_name("John")
contact.set_last_name("Doe")
contact.set_email("john.doe@example.com")
contact.set_phone("+1234567890")
contact.set_subject("Test Subject")
contact.set_message("This is a test message to verify encryption is working properly.")
contact.save()

print(f"✅ Contact created with ID: {contact.id}")
print(f"✅ Submitted at: {contact.submitted_at}")
print("\n--- Encrypted Data (as stored in database) ---")
print(f"First Name (encrypted): {contact.first_name_encrypted[:50]}...")
print(f"Email (encrypted): {contact.email_encrypted[:50]}...")

print("\n--- Decrypted Data (readable) ---")
print(f"Full Name: {contact.get_full_name()}")
print(f"Email: {contact.get_email()}")
print(f"Phone: {contact.get_phone()}")
print(f"Subject: {contact.get_subject()}")
print(f"Message: {contact.get_message()}")

print("\n✅ Encryption/Decryption working correctly!")
print(f"\nYou can view this contact in admin at: http://127.0.0.1:8000/admin/main/contact/{contact.id}/change/")
