import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.contrib.auth.models import User
from crm.models import Project

# Get CRM user
crm_user = User.objects.filter(profile__role='crm').first()
print(f"CRM User: {crm_user.username} ({crm_user.get_full_name()})")

# Get projects assigned to CRM
projects = Project.objects.filter(crm=crm_user)
print(f"\nProjects assigned to CRM: {projects.count()}")

for project in projects:
    print(f"\n  Project ID: {project.project_id}")
    print(f"  Title: {project.title}")
    print(f"  Client: {project.client.get_full_name()}")
    print(f"  Status: {project.get_status_display()}")
    print(f"  URL: /crm/projects/{project.project_id}/")

print("\n" + "=" * 60)
print("Login credentials:")
print("  URL: http://127.0.0.1:8000/crm/staff/login/")
print("  Username: crm")
print("  Password: crm123")
print("=" * 60)
