import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Payment, Project, User

print("\n" + "="*80)
print("CRM PAYMENT VERIFICATION TEST")
print("="*80 + "\n")

# Get all CRM users
crm_users = User.objects.filter(profile__role='crm')
print(f"CRM Users: {crm_users.count()}")
for crm in crm_users:
    print(f"  - {crm.get_full_name()} ({crm.email})")
    
    # Get projects assigned to this CRM
    projects = Project.objects.filter(crm=crm)
    print(f"    Assigned Projects: {projects.count()}")
    
    # Get pending payments for these projects
    pending_payments = Payment.objects.filter(
        project__crm=crm,
        status='pending'
    )
    print(f"    Pending Payments: {pending_payments.count()}")
    
    for payment in pending_payments:
        print(f"      - ${payment.amount} for {payment.project.title}")
    print()

# Get all payments
all_payments = Payment.objects.all()
print(f"\nTotal Payments in Database: {all_payments.count()}")
for payment in all_payments:
    print(f"  - ${payment.amount} | {payment.project.title} | Status: {payment.status}")
    print(f"    Project CRM: {payment.project.crm.get_full_name() if payment.project.crm else 'Not assigned'}")
    print()

# Get all pending payments
pending = Payment.objects.filter(status='pending')
print(f"Total Pending Payments: {pending.count()}")
