import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.contrib.auth.models import User
from crm.models import Task

# Get Employee user
employee_user = User.objects.filter(profile__role='employee').first()
print(f"Employee: {employee_user.username} ({employee_user.get_full_name()})")

# Get tasks assigned to employee
tasks = Task.objects.filter(assigned_to=employee_user)
print(f"\nTasks assigned to employee: {tasks.count()}")

# Statistics
total_tasks = tasks.count()
completed_tasks = tasks.filter(status='completed').count()
in_progress_tasks = tasks.filter(status='in_progress').count()
pending_tasks = tasks.filter(status='pending').count()

print(f"\n" + "=" * 60)
print("TASK STATISTICS")
print("=" * 60)
print(f"Total Tasks: {total_tasks}")
print(f"Pending: {pending_tasks}")
print(f"In Progress: {in_progress_tasks}")
print(f"Completed: {completed_tasks}")
print("=" * 60)

print("\nTASK DETAILS:")
for task in tasks:
    print(f"\n  • {task.title}")
    print(f"    Project: {task.project.title}")
    print(f"    Status: {task.get_status_display()}")
    print(f"    Priority: {task.get_priority_display()}")
    print(f"    Due Date: {task.due_date if task.due_date else 'No deadline'}")
    print(f"    Assigned by: {task.assigned_by.get_full_name() if task.assigned_by else 'N/A'}")

print("\n" + "=" * 60)
print("LOGIN CREDENTIALS:")
print("  URL: http://127.0.0.1:8000/crm/staff/login/")
print("  Username: employee")
print("  Password: employee123")
print("  Dashboard: http://127.0.0.1:8000/employee/dashboard/")
print("=" * 60)

print("\nFEATURES:")
print("  ✓ View all assigned tasks")
print("  ✓ Filter tasks by status (All, Pending, In Progress, Completed)")
print("  ✓ Start pending tasks (changes status to 'In Progress')")
print("  ✓ Mark in-progress tasks as complete")
print("  ✓ View task details (project, priority, due date)")
print("  ✓ Statistics cards showing task breakdown")
print("=" * 60)
