import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.contrib.auth.models import User
from crm.models import Task

# Get Employee user
employee_user = User.objects.filter(profile__role='employee').first()
print(f"Employee: {employee_user.username} ({employee_user.get_full_name()})")

# Get tasks assigned to employee
tasks = Task.objects.filter(assigned_to=employee_user)
print(f"\nTasks assigned to employee: {tasks.count()}")

for task in tasks:
    print(f"\n" + "=" * 60)
    print(f"Task: {task.title}")
    print(f"Task ID: {task.task_id}")
    print(f"Project: {task.project.title}")
    print(f"Status: {task.get_status_display()}")
    print(f"Priority: {task.get_priority_display()}")
    print(f"Description: {task.description}")
    print(f"Assigned by: {task.assigned_by.get_full_name() if task.assigned_by else 'N/A'}")
    print(f"Due Date: {task.due_date if task.due_date else 'No deadline'}")
    print(f"Created: {task.created_at}")
    if task.completed_at:
        print(f"Completed: {task.completed_at}")
    print(f"\nDetail URL: http://127.0.0.1:8000/employee/tasks/{task.task_id}/")
    print("=" * 60)

print("\n" + "=" * 60)
print("TEST STEPS:")
print("1. Login at: http://127.0.0.1:8000/crm/staff/login/")
print("   Username: employee")
print("   Password: employee123")
print("2. Go to dashboard: http://127.0.0.1:8000/employee/dashboard/")
print("3. Click 'View Details' button on any task")
print("4. You should see the task detail page with:")
print("   - Status timeline (visual progress)")
print("   - Complete task information")
print("   - Project information")
print("   - Action buttons (Start/Complete)")
print("=" * 60)
