"""
Test script to verify new assessment submissions are encrypted
"""

from assessment.models import ProfileAssessment

print("=" * 60)
print("TESTING NEW ASSESSMENT SUBMISSION ENCRYPTION")
print("=" * 60)

# Create a new test assessment manually (simulating form submission)
print("\n1. Creating new assessment with encryption...")

assessment = ProfileAssessment()

# Test data
test_data = {
    'first_name': 'John',
    'last_name': 'Doe',
    'email': 'john.doe@test.com',
    'phone_number': '1234567890',
    'current_location': 'New York, USA'
}

# Set encrypted fields using setter methods
assessment.set_first_name(test_data['first_name'])
assessment.set_last_name(test_data['last_name'])
assessment.set_email(test_data['email'])
assessment.set_phone_number(test_data['phone_number'])
assessment.set_current_location(test_data['current_location'])

# Set non-encrypted fields
assessment.country_code = '+1'
assessment.field_of_expertise = 'Technology & Engineering'
assessment.years_of_experience = '3-5 years'

# Set some criteria scores
assessment.original_contributions = 2
assessment.published_material = 1
assessment.judging_work = 2
assessment.scholarly_articles = 2
assessment.leading_role = 1
assessment.high_salary = 2
assessment.exhibitions = 0
assessment.membership = 1
assessment.awards = 1
assessment.commercial_success = 0

# Save the assessment
assessment.save()
assessment.calculate_scores()

print(f"✅ New assessment created with ID: {assessment.assessment_id}")

print("\n2. Verifying encryption...")
print("-" * 40)

# Check if data is encrypted
print("ENCRYPTED DATA (binary format):")
print(f"First Name: {assessment.first_name_encrypted[:50]}...")
print(f"Last Name:  {assessment.last_name_encrypted[:50]}...")
print(f"Email:      {assessment.email_encrypted[:50]}...")
print(f"Phone:      {assessment.phone_number_encrypted[:50]}...")
print(f"Location:   {assessment.current_location_encrypted[:50]}...")

print("\nDECRYPTED DATA (readable):")
print(f"Full Name:  {assessment.get_full_name()}")
print(f"Email:      {assessment.get_email()}")
print(f"Phone:      {assessment.get_phone_number()}")
print(f"Location:   {assessment.get_current_location()}")

# Verify encryption is working
is_encrypted = (
    assessment.first_name_encrypted.startswith(b'gAAAAAB') and
    assessment.email_encrypted.startswith(b'gAAAAAB') and
    len(assessment.first_name_encrypted) > 50
)

print(f"\n3. Encryption Status:")
print("-" * 40)
if is_encrypted:
    print("✅ Data is properly encrypted!")
    print("✅ Fernet encryption format detected")
    print("✅ Binary data stored in database")
else:
    print("❌ Data is NOT encrypted!")
    print("❌ Check encryption methods")

print(f"\n4. Assessment Results:")
print("-" * 40)
print(f"Total Score: {assessment.total_score}/30")
print(f"Percentage: {assessment.percentage_score:.1f}%")
print(f"Status: {assessment.eligibility_status}")

print("\n" + "=" * 60)
print("TEST COMPLETE")
print("=" * 60)