"""
Test script to verify payment details display
"""
import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.contrib.auth.models import User
from crm.models import Payment, Project

def test_payment_details():
    """Test payment details display"""
    print("\n" + "="*60)
    print("PAYMENT DETAILS TEST")
    print("="*60)
    
    # Get all pending payments
    pending_payments = Payment.objects.filter(status='pending')
    
    print(f"\n✓ Found {pending_payments.count()} pending payment(s)")
    
    for payment in pending_payments:
        print(f"\n{'='*60}")
        print(f"Payment ID: {payment.payment_id}")
        print(f"Project: {payment.project.title}")
        print(f"Client: {payment.client.get_full_name()}")
        print(f"Amount: ${payment.amount}")
        print(f"Payment Method: {payment.get_payment_method_display()}")
        print(f"Payment From: {payment.get_payment_from_display()}")
        print(f"Payment Date: {payment.payment_date}")
        print(f"Transaction ID: {payment.transaction_id}")
        print(f"Screenshot: {payment.screenshot.url if payment.screenshot else 'No screenshot'}")
        print(f"Status: {payment.get_status_display()}")
        
        # Check if project has CRM assigned
        if payment.project.crm:
            print(f"✓ CRM Assigned: {payment.project.crm.get_full_name()}")
        else:
            print(f"⚠ No CRM assigned to this project")
    
    # Get all payments
    all_payments = Payment.objects.all()
    print(f"\n{'='*60}")
    print(f"TOTAL PAYMENTS: {all_payments.count()}")
    print(f"  - Pending: {all_payments.filter(status='pending').count()}")
    print(f"  - Approved: {all_payments.filter(status='approved').count()}")
    print(f"  - Rejected: {all_payments.filter(status='rejected').count()}")
    
    # Check CRM user
    crm_users = User.objects.filter(profile__role='crm')
    print(f"\n✓ Found {crm_users.count()} CRM user(s)")
    for crm in crm_users:
        assigned_projects = Project.objects.filter(crm=crm)
        pending_for_crm = Payment.objects.filter(
            project__crm=crm,
            status='pending'
        )
        print(f"  - {crm.get_full_name()}: {assigned_projects.count()} projects, {pending_for_crm.count()} pending payments")
    
    print("\n" + "="*60)
    print("TEST COMPLETE")
    print("="*60)
    print("\nNext steps:")
    print("1. Visit http://127.0.0.1:8000/crm/dashboard/ (CRM login)")
    print("2. Check the 'Pending Payments' section")
    print("3. Verify transaction ID and screenshot link are visible")
    print("4. Visit http://127.0.0.1:8000/crm-admin/payments/ (Admin login)")
    print("5. Verify all payment details are displayed")

if __name__ == '__main__':
    test_payment_details()
