import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.contrib.auth.models import User
from crm.models import Project, Task

# Get Project Manager user
pm_user = User.objects.filter(profile__role='project_manager').first()
print(f"Project Manager: {pm_user.username} ({pm_user.get_full_name()})")

# Get projects assigned to PM
projects = Project.objects.filter(project_manager=pm_user)
print(f"\nProjects assigned to PM: {projects.count()}")

for project in projects:
    print(f"  - {project.title}")
    print(f"    Client: {project.client.get_full_name()}")
    print(f"    CRM: {project.crm.get_full_name() if project.crm else 'Not assigned'}")
    print(f"    Status: {project.get_status_display()}")

# Get tasks for PM's projects
tasks = Task.objects.filter(project__project_manager=pm_user)
print(f"\nTasks in PM's projects: {tasks.count()}")

print("\n" + "=" * 60)
print("Login credentials:")
print("  URL: http://127.0.0.1:8000/crm/staff/login/")
print("  Username: project")
print("  Password: project123")
print("  Dashboard: http://127.0.0.1:8000/pm/dashboard/")
print("=" * 60)
