import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.contrib.auth.models import User
from crm.models import Project, Task

# Get Project Manager user
pm_user = User.objects.filter(profile__role='project_manager').first()
print(f"Project Manager: {pm_user.username} ({pm_user.get_full_name()})")

# Get PM's project
project = Project.objects.filter(project_manager=pm_user).first()
print(f"\nProject: {project.title}")
print(f"Project ID: {project.project_id}")

# Get tasks for this project
tasks = Task.objects.filter(project=project)
total_tasks = tasks.count()
completed_tasks = tasks.filter(status='completed').count()
in_progress_tasks = tasks.filter(status='in_progress').count()
pending_tasks = tasks.filter(status='pending').count()

# Calculate completion percentage
completion_percentage = 0
if total_tasks > 0:
    completion_percentage = round((completed_tasks / total_tasks) * 100)

print(f"\n" + "=" * 60)
print("TASK STATISTICS")
print("=" * 60)
print(f"Total Tasks: {total_tasks}")
print(f"Completed: {completed_tasks}")
print(f"In Progress: {in_progress_tasks}")
print(f"Pending: {pending_tasks}")
print(f"\nCompletion Percentage: {completion_percentage}%")
print("=" * 60)

print("\nTASK DETAILS:")
for task in tasks:
    print(f"\n  • {task.title}")
    print(f"    Status: {task.get_status_display()}")
    print(f"    Priority: {task.get_priority_display()}")
    print(f"    Assigned to: {task.assigned_to.get_full_name() if task.assigned_to else 'Unassigned'}")

print("\n" + "=" * 60)
print("VIEW PROGRESS BAR:")
print(f"URL: http://127.0.0.1:8000/pm/projects/{project.project_id}/")
print("=" * 60)
