"""
Test script to verify staff login URL changes
"""
import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.urls import reverse

def test_staff_urls():
    """Test that staff URLs are correctly configured"""
    print("=" * 60)
    print("STAFF URL CONFIGURATION TEST")
    print("=" * 60)
    
    # Test staff login URL
    try:
        staff_login_url = reverse('staff_login')
        print(f"\n✓ Staff Login URL: {staff_login_url}")
        print(f"  Full URL: http://127.0.0.1:8000{staff_login_url}")
    except Exception as e:
        print(f"\n❌ Error getting staff login URL: {e}")
    
    # Test staff register URL
    try:
        staff_register_url = reverse('staff_register')
        print(f"\n✓ Staff Register URL: {staff_register_url}")
        print(f"  Full URL: http://127.0.0.1:8000{staff_register_url}")
    except Exception as e:
        print(f"\n❌ Error getting staff register URL: {e}")
    
    # Test client URLs (should still work)
    try:
        client_login_url = reverse('client_login')
        print(f"\n✓ Client Login URL: {client_login_url}")
        print(f"  Full URL: http://127.0.0.1:8000{client_login_url}")
    except Exception as e:
        print(f"\n❌ Error getting client login URL: {e}")
    
    # Test admin dashboard URL
    try:
        admin_dashboard_url = reverse('admin_dashboard')
        print(f"\n✓ Admin Dashboard URL: {admin_dashboard_url}")
        print(f"  Full URL: http://127.0.0.1:8000{admin_dashboard_url}")
    except Exception as e:
        print(f"\n❌ Error getting admin dashboard URL: {e}")
    
    print("\n" + "=" * 60)
    print("URL SECURITY STATUS")
    print("=" * 60)
    
    print("\n✅ PUBLIC URLs (visible on website):")
    print("   - Client Login: /client/login/")
    print("   - Client Register: /client/register/")
    print("   - Assessment: /assessment/")
    
    print("\n🔒 HIDDEN URLs (not linked on website):")
    print("   - Staff Login: /system/auth/staff-portal/")
    print("   - Staff Register: /system/auth/staff-register/")
    print("   - Admin Dashboard: /crm-admin/dashboard/")
    
    print("\n" + "=" * 60)
    print("SECURITY RECOMMENDATIONS")
    print("=" * 60)
    
    print("\n1. ✓ Staff login URL is now hidden")
    print("2. ✓ No public links to staff portal")
    print("3. ⚠️  Share staff URL only with authorized personnel")
    print("4. ⚠️  Use HTTPS in production")
    print("5. ⚠️  Enable rate limiting on login attempts")
    print("6. ⚠️  Monitor failed login attempts")
    
    print("\n" + "=" * 60)
    print("TEST COMPLETE")
    print("=" * 60)

if __name__ == '__main__':
    test_staff_urls()
