import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from django.contrib.auth.models import User
from crm.models import Project, Task

# Get Project Manager user
pm_user = User.objects.filter(profile__role='project_manager').first()
print(f"Project Manager: {pm_user.username} ({pm_user.get_full_name()})")

# Get PM's project
project = Project.objects.filter(project_manager=pm_user).first()
print(f"\nProject: {project.title}")
print(f"Project ID: {project.project_id}")

# Get tasks for this project
tasks = Task.objects.filter(project=project)
print(f"\nTasks in project: {tasks.count()}")

for task in tasks:
    print(f"\n  Task: {task.title}")
    print(f"  Description: {task.description}")
    print(f"  Priority: {task.get_priority_display()}")
    print(f"  Status: {task.get_status_display()}")
    print(f"  Assigned to: {task.assigned_to.get_full_name() if task.assigned_to else 'Unassigned'}")
    print(f"  Due date: {task.due_date if task.due_date else 'No deadline'}")

# Get employees
employees = User.objects.filter(profile__role='employee')
print(f"\n\nAvailable Employees: {employees.count()}")
for emp in employees:
    print(f"  - {emp.username} ({emp.get_full_name()})")

print("\n" + "=" * 60)
print("TEST STEPS:")
print("1. Login at: http://127.0.0.1:8000/crm/staff/login/")
print("   Username: project")
print("   Password: project123")
print("2. Go to project detail: http://127.0.0.1:8000/pm/projects/" + str(project.project_id) + "/")
print("3. Click 'Create Task' button")
print("4. Fill in task details and submit")
print("5. Task should appear in the tasks table")
print("=" * 60)
