import os
import django

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'myproject.settings')
django.setup()

from crm.models import Task
from django.utils import timezone

# Get all tasks
tasks = Task.objects.all()

print("=" * 60)
print("AVAILABLE TASKS")
print("=" * 60)

for i, task in enumerate(tasks, 1):
    print(f"\n{i}. {task.title}")
    print(f"   Status: {task.get_status_display()}")
    print(f"   Project: {task.project.title}")
    print(f"   Task ID: {task.task_id}")

print("\n" + "=" * 60)
print("UPDATE TASK STATUS")
print("=" * 60)

# Update first task to completed as example
if tasks.exists():
    task = tasks.first()
    print(f"\nUpdating task: {task.title}")
    print(f"Old status: {task.get_status_display()}")
    
    # Uncomment one of these to change status:
    # task.status = 'in_progress'
    # task.status = 'completed'
    # task.completed_at = timezone.now()
    # task.save()
    
    print("\nTo update task status, uncomment the lines in the script:")
    print("  task.status = 'in_progress'  # or 'completed'")
    print("  task.save()")
    print("\nOr use Django admin to change task status")
    print(f"Admin URL: http://127.0.0.1:8000/admin/crm/task/{task.task_id}/change/")

print("\n" + "=" * 60)
